<?php
namespace MascotCoreFINCLIX\Widgets\ThemeButton\Skins;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Skin_Base as Elementor_Skin_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Skin_Style6 extends Elementor_Skin_Base {

	protected function _register_controls_actions() {
		add_action( 'elementor/element/tm-ele-theme-button/tm_general/after_section_end', [ $this, 'register_layout_controls' ] );
	}

	public function get_id() {
		return 'skin-style6';
	}


	public function get_title() {
		return __( 'Theme Button Style6', 'mascot-core-finclix' );
	}


	public function register_layout_controls( Widget_Base $widget ) {
		$this->parent = $widget;
	}

	public function render() {
		$settings = $this->parent->get_settings_for_display();

		$direction_suffix = is_rtl() ? '.rtl' : '';
		wp_enqueue_style( 'tm-theme-button-style6', MASCOT_CORE_FINCLIX_ASSETS_URI . '/css/shortcodes/theme-button/theme-button-style6' . $direction_suffix . '.css' );

		//link url
		$settings['button']['target'] = ( $settings['link'] && $settings['link']['is_external'] ) ? ' target="_blank"' : '';
		$settings['button']['url'] = ( $settings['link'] && $settings['link']['url'] ) ? $settings['link']['url'] : '';


		$settings['settings'] = $settings;

		//Produce HTML version by using the parameters (filename, variation, folder name, parameters, shortcode_ob_start)
		$html = mascot_core_finclix_get_shortcode_template_part( 'theme-button', $settings['_skin'], 'theme-button/tpl', $settings, true );

		echo $html;
	}
}
