<?php
namespace MASCOTCOREFINCLIX\CPT\SidePushPanel;

use MASCOTCOREFINCLIX\Lib;

/**
 * Singleton class
 * class CPT_SidePushPanel
 * @package MASCOTCOREFINCLIX\CPT\SidePushPanel;
 */
final class CPT_SidePushPanel implements Lib\Mascot_Core_Finclix_Interface_PostType {

	/**
	 * @var string
	 */
	public 	$ptKey;
	public 	$ptKeyRewriteBase;
	private $ptMenuIcon;
	private $ptSingularName;
	private $ptPluralName;

	/**
	 * Call this method to get singleton
	 *
	 * @return CPT_SidePushPanel
	 */
	public static function Instance() {
		static $inst = null;
		if ($inst === null) {
			$inst = new CPT_SidePushPanel();
		}
		return $inst;
	}

	/**
	 * Private ctor so nobody else can instance it
	 *
	 */
	private function __construct() {
		$this->ptSingularName = esc_html__( 'Parts - Side Push Panel', 'mascot-core-finclix' );
		$this->ptPluralName = esc_html__( 'Parts - Side Push Panel', 'mascot-core-finclix' );
		$this->ptKey = 'side-push-panel';
		$this->ptKeyRewriteBase = $this->ptKey;
		$this->ptMenuIcon = 'dashicons-mascot';
		add_filter( 'manage_edit-'.$this->ptKey.'_columns', array($this, 'customColumnsSettings') ) ;
		add_filter( 'manage_'.$this->ptKey.'_posts_custom_column', array($this, 'customColumnsContent') ) ;
	}

	/**
	 * @return string
	 */
	public function getPTKey() {
		return $this->ptKey;
	}

	/**
	 * registers custom post type & Tax
	 */
	public function register() {
		$this->registerCustomPostType();
	}

	/**
	 * Regsiters custom post type
	 */
	private function registerCustomPostType() {

		$labels = array(
			'name'					=> $this->ptPluralName,
			'singular_name'			=> $this->ptPluralName . ' ' . esc_html__( 'Item', 'mascot-core-finclix' ),
			'menu_name'				=> $this->ptPluralName,
			'name_admin_bar'		=> $this->ptPluralName,
			'archives'				=> esc_html__( 'Item Archives', 'mascot-core-finclix' ),
			'attributes'			=> esc_html__( 'Item Attributes', 'mascot-core-finclix' ),
			'parent_item_colon'		=> esc_html__( 'Parent Item:', 'mascot-core-finclix' ),
			'all_items'				=> esc_html__( 'All Items', 'mascot-core-finclix' ),
			'add_new_item'			=> esc_html__( 'Add New Item', 'mascot-core-finclix' ),
			'add_new'				=> esc_html__( 'Add New', 'mascot-core-finclix' ),
			'new_item'				=> esc_html__( 'New Item', 'mascot-core-finclix' ),
			'edit_item'				=> esc_html__( 'Edit Item', 'mascot-core-finclix' ),
			'update_item'			=> esc_html__( 'Update Item', 'mascot-core-finclix' ),
			'view_item'				=> esc_html__( 'View Item', 'mascot-core-finclix' ),
			'view_items'			=> esc_html__( 'View Items', 'mascot-core-finclix' ),
			'search_items'			=> esc_html__( 'Search Item', 'mascot-core-finclix' ),
			'not_found'				=> esc_html__( 'Not found', 'mascot-core-finclix' ),
			'not_found_in_trash'	=> esc_html__( 'Not found in Trash', 'mascot-core-finclix' ),
			'featured_image'		=> esc_html__( 'Featured Image', 'mascot-core-finclix' ),
			'set_featured_image'	=> esc_html__( 'Set featured image', 'mascot-core-finclix' ),
			'remove_featured_image'	=> esc_html__( 'Remove featured image', 'mascot-core-finclix' ),
			'use_featured_image'	=> esc_html__( 'Use as featured image', 'mascot-core-finclix' ),
			'insert_into_item'		=> esc_html__( 'Insert into item', 'mascot-core-finclix' ),
			'uploaded_to_this_item'	=> esc_html__( 'Uploaded to this item', 'mascot-core-finclix' ),
			'items_list'			=> esc_html__( 'Items list', 'mascot-core-finclix' ),
			'items_list_navigation'	=> esc_html__( 'Items list navigation', 'mascot-core-finclix' ),
			'filter_items_list'		=> esc_html__( 'Filter items list', 'mascot-core-finclix' ),
		);

		$args = array(
			'label'						=> $this->ptSingularName,
			'description'				=> esc_html__( 'Post Type Description', 'mascot-core-finclix' ),
			'labels'					=> $labels,
			'supports'					=> array( 'title', 'editor', ),
			'hierarchical'				=> false,
			'public'					=> true,
			'show_ui'					=> true,
			'show_in_menu'				=> true,
			'menu_position'				=> 31,
			'menu_icon'					=> $this->ptMenuIcon,
			'show_in_admin_bar'			=> true,
			'show_in_nav_menus'			=> true,
			'can_export'				=> true,
			'has_archive'				=> false,
			'exclude_from_search'		=> true,
			'publicly_queryable'		=> true,
			'capability_type'			=> 'page',
			'rewrite'					=> array( 'slug' => $this->ptKeyRewriteBase, 'with_front' => false ),
		);
		register_post_type( $this->ptKey, $args );

	}

	/**
	 * Custom Columns Settings
	 */
	public function customColumnsSettings( $columns ) {

		$columns = array(
			'cb'			=> '<input type="checkbox" />',
			'title'			=> esc_html__( 'Title', 'mascot-core-finclix' ),
			'active-side-push-panel'	=> esc_html__( 'Currently Active Side Push Panel', 'mascot-core-finclix' ),
			'date'			=> esc_html__( 'Date', 'mascot-core-finclix' ),
		);
		return $columns;
	}

	/**
	 * Custom Columns Content
	 */
	public function customColumnsContent( $columns ) {
		global $post;
		switch( $columns ) {
			case 'active-side-push-panel' :
				if( mascot_core_finclix_theme_installed() ) {
					$active_headertop_id = finclix_get_redux_option( 'header-settings-choose-side-push-panel-cpt-widget-area', 'default' );
					if( $post->ID == $active_headertop_id ) {
						echo '<a class="tm-btn tm-btn-danger tm-btn-sm disabled">Active</a>';
					}
				}
			break;

			default :
			break;
		}
	}

}