<?php
if( !class_exists( 'Chart_Builder_External_DB_Query' ) ){
	ob_start();

    /**
	 * Class Chart_Builder_External_DB_Query
	 * Class contains functions to interact with external database
	 *
	 * Main functionality belong to inserting, updating and deleting of
	 * Also chart settings and options
	 *
	 * Hooks used in the class
	 * @hooks           @filters        ays_chart_item_save_options
	 *                                  ays_chart_item_save_settings
	 *
	 * Database tables without prefixes
	 * @tables          charts
	 *                  charts_meta
	 *
	 * @param           $plugin_name
	 *
	 * @since           1.0.0
	 * @package         Chart_Builder
	 * @subpackage      Chart_Builder/includes
	 * @author          Chart Builder Team <info@ays-pro.com>
	 */

	class Chart_Builder_External_DB_Query extends Chart_Builder_DB_Query {
        protected $db_host;
        protected $db_name;
        protected $db_user;
        protected $db_password;
        protected $db_port;
        public $external_db_connection;

        public function __construct($query, $chart_id, $db_host, $db_name, $db_user, $db_password, $db_port) {
            parent::__construct($query, $chart_id);
            
            $this->db_host = $db_host;
            $this->db_name = $db_name;
            $this->db_user = $db_user;
            $this->db_password = $db_password;
            $this->db_port = $db_port;
            
            $this->connect_to_external_db();
        }

        protected function connect_to_external_db() {
            try {
                // Create a new PDO connection
                $dsn = "mysql:host={$this->db_host};dbname={$this->db_name};charset=utf8mb4;port={$this->db_port}";
                $this->external_db_connection = new PDO($dsn, $this->db_user, $this->db_password);

                // Set error mode to exception for better error handling
                $this->external_db_connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                return true;
            } catch (PDOException $e) {
                $this->_error = 'Connection failed: ' . $e->getMessage();
                return false;
            }
        }
    }
}