(function($) {
    'use strict';
    function AysChartBuilder(element, options){
        this.el = element;
        this.$el = $(element);
        this.ajaxAction = 'ays_chart_admin_ajax';
        this.htmlClassPrefix = 'ays-chart-';
        this.htmlNamePrefix = 'ays_';
        this.dbOptions = undefined;
        this.chartSourceData = undefined;
		this.chartObj = undefined;
		this.chartOptions = null;
		this.chartData = null;
		this.chartDataArray = null;
		this.chartTempData = null;
		this.chartType = 'pie_chart';
		this.gSheetcolumnOrder = null;

		this.enableGeoUrl = false;

		this.chartSources = {
			'line_chart'   			: 'Line Chart',
			'bar_chart'    			: 'Bar Chart',
			'pie_chart'    			: 'Pie Chart',
			'column_chart' 			: 'Column Chart',
			'donut_chart'  			: 'Donut Chart',
			'histogram'    			: 'Histogram',
			'geo_chart'    			: 'Geo Chart',
			'org_chart'    			: 'Org Chart',
			'area_chart'   			: 'Area Chart',
			'gauge_chart'  			: 'Gauge Chart',
			'combo_chart'  			: 'Combo Chart',
			'stepped_area_chart'    : 'Stepped Area Chart',
			'bubble_chart'          : 'Bubble Chart',
			'scatter_chart'         : 'Scatter Chart',
			'table_chart'           : 'Table Chart',
			'timeline_chart'        : 'Timeline Chart',
			'candlestick_chart'     : 'Candlestick Chart',
			'gantt_chart'           : 'Gantt Chart',
			'sankey_diagram'        : 'Sankey Diagram',
			'treemap'               : 'Treemap',
			'word_tree'             : 'Word Tree',
			'3dpie_chart'           : '3D Pie Chart',
		}

		this.nonManualTypes = [
			'bubble_chart',
			'scatter_chart',
			'table_chart',
			'timeline_chart',
			'candlestick_chart',
			'gantt_chart',
			'sankey_diagram',
			'treemap',
			'word_tree',
		];

        this.init();

        return this;
    }

    AysChartBuilder.prototype.init = function() {
        var _this = this;
		_this.chartSourceData = window.ChartBuilderSourceData;
        _this.setEvents();
        _this.initLibraries();
        _this.setAccordionEvents();

		_this.initDbImport();
		_this.initExternalDbImport();
		_this.initGoogleSheetImport();
		_this.initFileImport();
		_this.initQuizDBImport();
		_this.initWoocommerceImport();
	};

	// Set events
    AysChartBuilder.prototype.setEvents = function(e){
        var _this = this;

		/* == Choose poll type from modal == */
			_this.$el.on('dblclick'  , '.'+_this.htmlClassPrefix+'layer_box_blocks label.'+_this.htmlClassPrefix+'dblclick-layer:not(.'+_this.htmlClassPrefix+'type-pro-feature)', function(){
				_this.$el.find('.'+_this.htmlClassPrefix+'select_button_layer input.'+_this.htmlClassPrefix+'layer_button').trigger('click');
			}); 

			_this.$el.on('change'  , '.'+_this.htmlClassPrefix+'choose-source', function(){
				_this.$el.find('.'+_this.htmlClassPrefix+'select_button_layer input.'+_this.htmlClassPrefix+'layer_button').prop('disabled',false).attr("data-type" , $(this).val());
			}); 
			
			_this.$el.on('click', '.'+_this.htmlClassPrefix+'layer_button' ,function(){
				var getCheckedChartTpye = _this.$el.find('.'+_this.htmlClassPrefix+'choose-source:checked').val();
				_this.$el.find('.'+_this.htmlClassPrefix+'layer_container').css({'position':'unset' , 'display':'none'});
				_this.$el.find('.'+_this.htmlClassPrefix+'type-info-box-text-changeable').text(_this.chartSources[getCheckedChartTpye]);
				_this.$el.find('.'+_this.htmlClassPrefix+'nav-tab-chart.nav-tab[data-tab="tab4"]').text(_this.chartSourceData.chartTypesNames[getCheckedChartTpye]+" settings");
				_this.$el.find('.'+_this.htmlClassPrefix+'advanced-settings .ays-accordion-options-container:first-child legend.ays-accordion-options-header span').text(_this.chartSourceData.chartTypesNames[getCheckedChartTpye]+" settings");
				_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-type').val(getCheckedChartTpye);
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').attr('id' , _this.htmlClassPrefix+getCheckedChartTpye);
				_this.chartSourceData.source = (getCheckedChartTpye != "org_chart") ? _this.chartSourceData.source.commonTypeCharts : _this.chartSourceData.source.orgTypeChart;

				if (getCheckedChartTpye != 'geo_chart' && getCheckedChartTpye != 'org_chart') {
					_this.chartSourceData.source.forEach(row => {
						row.pop();
					});
				}

				_this.chartType = getCheckedChartTpye;
				_this.updateChangeTypeData();
				_this.loadChartBySource();
				_this.configureOptions();
			});
		/* */

		/* == Tabulation == */
			_this.$el.on('click', '.nav-tab-wrapper a.nav-tab' , _this.changeTabs);
		/* */

		/* == Notifications dismiss button == */
			_this.$el.on('click', '.notice-dismiss', function (e) {
				_this.changeCurrentUrl('status');
			});

			_this.$el.on('click', '.toggle_ddmenu' , _this.toggleDDmenu);
		/* */

		/* == Import from file == */
			_this.$el.on('change', '#'+_this.htmlClassPrefix+'import-files-file-type', function (){
				_this.updateImportFileFormat($(this));
			});
		/* */

		/* Add Manual data */
			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'add-new-row-box', function(){
				_this.addChartDataRow();
			});

			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'add-new-column-box', function(){
				_this.addChartDataColumn();
			});

			_this.$el.on('click', '.'+_this.htmlClassPrefix+'show-on-chart-bttn', function(e){		
				e.preventDefault();
				if(_this.chartType != "org_chart" ) {
					_this.showOnChart();
				} else {
					_this.orgTypeShowOnChart();
				}
			});

		/* */

		/* Delete data */ 
			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'chart-source-data-remove-row', function(){
				_this.deleteChartDataRow($(this));
				_this.detectManualChange();
			}); 
			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'chart-source-data-remove-col', function(){
				_this.deleteChartDataColumn($(this));
				_this.detectManualChange();
			}); 
			_this.$el.on('mouseenter', '.'+_this.htmlClassPrefix+'chart-source-data-remove-block', function() {
				$(this).find('path').css('fill', '#ff0000');
			});
			_this.$el.on('mouseleave', '.'+_this.htmlClassPrefix+'chart-source-data-remove-block', function() {
				$(this).find('path').css('fill', '#b8b8b8');
			});
		/* */
		
		/* Load data on the edit page */ 
			if(_this.chartSourceData.action == 'edit'){
				_this.chartType = _this.chartSourceData.chartType;
				_this.loadChartBySource();
				_this.configureOptions();
			}
		/* */

		/* Save with Ctrl + S */
			_this.$el.on('keydown', $(document), _this.quickSaveHotKeys);
		/* */

		// Submit buttons disabling
			_this.$el.on('click', '.'+_this.htmlClassPrefix+'loader-banner', _this.submitOnce);
		/* */
		
		// Disabling submit when press enter button on inputing
			$(document).on("keypress", '.ays-text-input', _this.disableSubmit);
		/* */

		// Modal close
			$(document).on('click', '.ays-close', function () {
				$(this).parents('.ays-modal').aysModal('hide');
			});

		// Changing source type to manual
			_this.$el.on('input', '.'+_this.htmlClassPrefix+'chart-source-data-content input', function () {
				_this.detectManualChange();
			});

		// Shortcode text for editor tooltip
			$(document).find('strong.ays-chart-shortcode-box').on('mouseleave', function(){
				var _this = $(this);
		
				_this.attr('data-original-title', aysChartBuilderAdmin.clickForCopy);
				_this.attr("data-bs-original-title", aysChartBuilderAdmin.clickForCopy);
				_this.attr("title", aysChartBuilderAdmin.clickForCopy);
			});

		// Quiz maker integration
			$(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').on('change', function () {
				_this.$el.find('.ays-chart-quiz-query-tooltip').attr('title', _this.chartSourceData.quiz_query_tooltips[this.value]);
				_this.$el.find('.ays-chart-quiz-query-tooltip').attr('data-bs-original-title', _this.chartSourceData.quiz_query_tooltips[this.value]);
				_this.quizMakerIntegrationConfig();
				_this.toggleQuizSelect(this);
			});

			$(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz').on('change', function () {
				_this.quizMakerIntegrationConfig();
			});

			$(window).on('load', function () {
				_this.toggleQuizSelect();
			});

		// Woocommerce integration
			_this.$el.find('#'+_this.htmlClassPrefix+'woocommerce-datas-select').on('change', function () {
				_this.$el.find('.ays-chart-woocommerce-datas-tooltip').attr('title', _this.chartSourceData.woocommerce_query_tooltips[this.value]);
				_this.$el.find('.ays-chart-woocommerce-datas-tooltip').attr('data-bs-original-title', _this.chartSourceData.woocommerce_query_tooltips[this.value]);
				_this.woocommerceIntegrationConfig();
			});

		// Options configuration
			_this.$el.find('#ays_use_chart_specific_db').on('change', function (el) {
				_this.toggleExternalDatabaseSpecificSettings(el)
			})

			$(document).find('#'+_this.htmlClassPrefix+'option-haxis-slanted-text').on('change', function () {
				var angleOption = $(document).find('#'+_this.htmlClassPrefix+'option-haxis-slanted-text-angle').parents('.'+_this.htmlClassPrefix+'options-section');
				if ($(this).val() !== 'false') {
					angleOption.removeClass('display_none');
				} else {
					angleOption.addClass('display_none');
				}
			});

			_this.$el.find('.'+_this.htmlClassPrefix+'toggle-hidden-option').on('change', function () {
				// var animationOptions = _this.$el.find('.'+_this.htmlClassPrefix+'hidden-options-section');
				var currentSettings = $(this).parents('.' + _this.htmlClassPrefix + 'settings-data-main-wrap')
				var hiddenSection = currentSettings.find('.' + _this.htmlClassPrefix + 'hidden-options-section');
				var notHiddenSection = currentSettings.find('.' + _this.htmlClassPrefix + 'not-hidden-options-section');

				if ($(this).is(':checked')) {
					hiddenSection.removeClass('display_none');
					notHiddenSection.addClass('display_none');
				} else {
					hiddenSection.addClass('display_none');
					notHiddenSection.removeClass('display_none');
				}
			});

			_this.$el.find('#ays-chart-option-enable-url').on('change', function (el) {
				_this.toggleGeoUrl(el);
			})

			_this.$el.on('click', '.ays-chart-select-org-img', function (e) {
				_this.openMediaUploaderForImage(e, $(this));
			});	

			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'chart-source-data-sort', function(){
				_this.sortDataByColumn($(this));
				_this.detectManualChange();
			});	

			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'charts-change-type-type', function(){
				_this.chartType = $(this).attr('data-type');
				_this.changeChartType();
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-change-type-type').css('backgroundColor', '#e7e7e7');
				$(this).css('backgroundColor', '#008cff63');
			});

		// Live preview
			_this.liveSettingsPreview();
    }

	AysChartBuilder.prototype.openMediaUploaderForImage = function(e, element) {
        e.preventDefault();
        var aysUploader = wp.media({
            title: 'Upload',
            button: {
                text: 'Upload'
            },
            library: {
                type: 'image'
            },
            multiple: false
        }).on('select', function () {
            var attachment = aysUploader.state().get('selection').first().toJSON();
            var hiddenInp = element.next('input#ays-chart-org-chart-branch-image-url');

            element.text( aysChartBuilderAdmin.editImage );
            hiddenInp.val(attachment.url);
        }).open();
        return false;
    }

	AysChartBuilder.prototype.updateChangeTypeData = function () {
		var _this = this;

		var container = _this.$el.find('.'+_this.htmlClassPrefix+'charts-change-type-add');
		var list = _this.chartSourceData.chartTypesConnections[_this.chartType];
		
		for (var type in list) {
			if (Object.hasOwnProperty.call(list, type)) {
				var url = list[type];
				var color = type === _this.chartType ? '#008cff63' : 'e7e7e7';
				
				var element = $('<div></div>', {
					class: _this.htmlClassPrefix+'charts-change-type-type',
					title: _this.chartSourceData.chartTypesNames[type]
				}).attr(
					'data-type', type
				).css(
					'backgroundColor', color
				);
				
				var icon = $('<img />', {
					src: _this.chartSourceData.imagesUrl+'/icons/'+url, 
					alt: _this.chartSourceData.chartTypesNames[type]
				}).appendTo(element);

				element.appendTo(container);
			}
		}	
		
	}

	AysChartBuilder.prototype.liveSettingsPreview = function () {
		var _this = this;

		// general settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-width').on('input', function () {
				var format = _this.$el.find('#'+_this.htmlClassPrefix+'option-width-format').val() == '%' ? '%' : '';
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').css('width', $(this).val() + format);
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-width-format').on('change', function () {
				var format = '%';
				if ($(this).val() == 'px') {
					format = '';
				}
				var value = _this.$el.find('#'+_this.htmlClassPrefix+'option-width').val();
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').css('width', value + format);
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-position').on('change', function () {
				var value = $(this).val();
				var val = '';
				switch (value) {
					case 'center':
						val = 'auto';
						break;
					case 'right':
						val = 'auto 0 auto auto';
						break;
					case 'left':
						val = 'auto auto auto 0';
						break;
					default:
						break;
				}
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').css('margin', val);
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-height').on('input', function () {
				var format = _this.$el.find('#'+_this.htmlClassPrefix+'option-height-format').val() == '%' ? '%' : '';
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').css('height', $(this).val() + format);
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-height-format').on('change', function () {
				var format = '';
				if ($(this).val() == '%') {
					format = '%';
				}
				var value = _this.$el.find('#'+_this.htmlClassPrefix+'option-height').val();
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').css('height', value + format);
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-font-size').on('input', function () {
				_this.chartOptions.fontSize = $(this).val();
				_this.chartSourceData.settings.font_size = _this.chartOptions.fontSize;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-background-color').on('input', function () {
				var isTransparent = _this.$el.find('#'+_this.htmlClassPrefix+'option-transparent-background').is(':checked');

				if (!isTransparent) {
					_this.chartOptions.backgroundColor.fill = $(this).val();
					_this.chartSourceData.settings.background_color = _this.chartOptions.backgroundColor.fill;
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-transparent-background').on('change', function () {
				var bgColor = _this.$el.find('#'+_this.htmlClassPrefix+'option-background-color').val();
				var chartBgColor = _this.$el.find('#'+_this.htmlClassPrefix+'option-chart-background-color').val();

				_this.chartSourceData.settings.transparent_background = $(this).is(':checked') ? 'checked' : '';
				_this.chartOptions.backgroundColor.fill = $(this).is(':checked') ? 'transparent' : bgColor;
				if (typeof _this.chartOptions.chartArea.backgroundColor !== 'undefined') {
					_this.chartOptions.chartArea.backgroundColor.fill = $(this).is(':checked') ? 'transparent' : chartBgColor;
				}
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-background-color').on('input', function () {
				var isTransparent = _this.$el.find('#'+_this.htmlClassPrefix+'option-transparent-background').is(':checked');

				if (!isTransparent) {
					_this.chartOptions.chartArea.backgroundColor.fill = $(this).val();
					_this.chartSourceData.settings.chart_background_color = _this.chartOptions.chartArea.backgroundColor.fill;
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-border-width').on('input', function () {
				_this.chartOptions.backgroundColor.strokeWidth = $(this).val();
				_this.chartSourceData.settings.border_width = _this.chartOptions.backgroundColor.strokeWidth;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-border-radius').on('input', function () {
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').css('border-radius', $(this).val() + 'px');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-border-width').on('input', function () {
				_this.chartOptions.chartArea.backgroundColor.strokeWidth = $(this).val();
				_this.chartSourceData.settings.chart_border_width = _this.chartOptions.chartArea.backgroundColor.strokeWidth;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-border-color').on('input', function () {
				_this.chartOptions.backgroundColor.stroke = $(this).val();
				_this.chartSourceData.settings.border_color = _this.chartOptions.backgroundColor.stroke;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-border-color').on('input', function () {
				_this.chartOptions.chartArea.backgroundColor.stroke = $(this).val();
				_this.chartSourceData.settings.chart_border_color = _this.chartOptions.chartArea.backgroundColor.stroke;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-left-margin').on('input', function () {
				_this.chartOptions.chartArea.left = $(this).val() === '' ? 'auto' : +$(this).val();
				_this.chartSourceData.settings.chart_left_margin = _this.chartOptions.chartArea.left;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-right-margin').on('input', function () {
				_this.chartOptions.chartArea.right = $(this).val() === '' ? 'auto' : +$(this).val();
				_this.chartSourceData.settings.chart_right_margin = _this.chartOptions.chartArea.right;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-top-margin').on('input', function () {
				_this.chartOptions.chartArea.top = $(this).val() === '' ? 'auto' : +$(this).val();
				_this.chartSourceData.settings.chart_top_margin = _this.chartOptions.chartArea.top;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-bottom-margin').on('input', function () {
				_this.chartOptions.chartArea.bottom = $(this).val() === '' ? 'auto' : +$(this).val();
				_this.chartSourceData.settings.chart_bottom_margin = _this.chartOptions.chartArea.bottom;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-interactivity').on('change', function () {
				_this.chartOptions.enableInteractivity = $(this).is(':checked');
				_this.chartSourceData.settings.enable_interactivity = _this.chartOptions.enableInteractivity ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-maximized-view').on('change', function () {
				_this.chartOptions.theme = $(this).is(':checked') ? 'maximized' : null;
				_this.chartSourceData.settings.maximized_view = $(this).is(':checked') ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

		// tooltip settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-tooltip-trigger').on('change', function () {
				_this.chartOptions.tooltip.trigger = $(this).val();
				_this.chartSourceData.settings.tooltip_trigger = _this.chartOptions.tooltip.trigger;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-show-color-code').on('change', function () {
				_this.chartOptions.tooltip.showColorCode = $(this).is(':checked');
				_this.chartSourceData.settings.show_color_code = _this.chartOptions.tooltip.showColorCode ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-tooltip-text-color').on('input', function () {
				_this.chartOptions.tooltip.textStyle.color = $(this).val();
				_this.chartSourceData.settings.tooltip_text_color = _this.chartOptions.tooltip.textStyle.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-tooltip-font-size').on('input', function () {
				_this.chartOptions.tooltip.textStyle.fontSize = $(this).val();
				_this.chartSourceData.settings.tooltip_font_size = _this.chartOptions.tooltip.textStyle.fontSize;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-tooltip-italic').on('change', function () {
				_this.chartOptions.tooltip.textStyle.italic = $(this).is(':checked');
				_this.chartSourceData.settings.tooltip_italic = _this.chartOptions.tooltip.textStyle.italic ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-tooltip-bold').on('change', function () {
				_this.chartOptions.tooltip.textStyle.bold = $(this).val();
				_this.chartSourceData.settings.tooltip_bold = _this.chartOptions.tooltip.textStyle.bold ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

		// legend settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-legend-position').on('change', function () {
				_this.chartOptions.legend.position = $(this).val();
				_this.chartSourceData.settings.legend_position = _this.chartOptions.legend.position;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-legend-alignment').on('change', function () {
				_this.chartOptions.legend.alignment = $(this).val();
				_this.chartSourceData.settings.legend_alignment = _this.chartOptions.legend.alignment;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-legend-font-color').on('input', function () {
				_this.chartOptions.legend.textStyle.color = $(this).val();
				_this.chartSourceData.settings.legend_font_color = _this.chartOptions.legend.textStyle.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-legend-font-size').on('input', function () {
				_this.chartOptions.legend.textStyle.fontSize = $(this).val();
				_this.chartSourceData.settings.legend_font_size = _this.chartOptions.legend.textStyle.fontSize;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-legend-italic').on('change', function () {
				_this.chartOptions.legend.textStyle.italic = $(this).is(':checked');
				_this.chartSourceData.settings.legend_italic = _this.chartOptions.legend.textStyle.italic ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-legend-bold').on('change', function () {
				_this.chartOptions.legend.textStyle.bold = $(this).is(':checked');
				_this.chartSourceData.settings.legend_bold = _this.chartOptions.legend.textStyle.bold ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

		// horizontal axis settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-title').on('input', function () {
				_this.chartOptions.hAxis.title = $(this).val();
				_this.chartSourceData.settings.haxis_title = _this.chartOptions.hAxis.title;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-text-position').on('change', function () {
				_this.chartOptions.hAxis.textPosition = $(this).val();
				_this.chartSourceData.settings.haxis_text_position = _this.chartOptions.hAxis.textPosition;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-text-direction').on('change', function () {
				_this.chartOptions.hAxis.direction = $(this).is(':checked') ? -1 : 1;
				_this.chartSourceData.settings.haxis_text_direction = _this.chartOptions.hAxis.direction;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-text-color').on('input', function () {
				_this.chartOptions.hAxis.textStyle.color = $(this).val();
				_this.chartSourceData.settings.haxis_text_color = _this.chartOptions.hAxis.textStyle.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-baseline-color').on('input', function () {
				_this.chartOptions.hAxis.baselineColor = $(this).val();
				_this.chartSourceData.settings.haxis_baseline_color = _this.chartOptions.hAxis.baselineColor;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-text-font-size').on('input', function () {
				_this.chartOptions.hAxis.textStyle.fontSize = $(this).val();
				_this.chartSourceData.settings.haxis_text_font_size = _this.chartOptions.hAxis.textStyle.fontSize;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-slanted-text').on('change', function () {
				_this.chartOptions.hAxis.slantedText = $(this).val();
				_this.chartSourceData.settings.haxis_slanted_text = _this.chartOptions.hAxis.slantedText;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-slanted-text-angle').on('input', function () {
				_this.chartOptions.hAxis.slantedTextAngle = $(this).val() != 0 ? $(this).val() : 30;
				_this.chartSourceData.settings.haxis_slanted_text_angle = _this.chartOptions.hAxis.slantedTextAngle;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-show-text-every').on('input', function () {
				_this.chartOptions.hAxis.showTextEvery = $(this).val() != 0 ? $(this).val() : 'automatic';
				_this.chartSourceData.settings.haxis_show_text_every = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-format').on('change', function () {
				_this.chartOptions.hAxis.format = $(this).val();
				_this.chartSourceData.settings.haxis_format = _this.chartOptions.hAxis.format;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-label-font-size').on('input', function () {
				_this.chartOptions.hAxis.titleTextStyle.fontSize = $(this).val();
				_this.chartSourceData.settings.haxis_label_font_size = _this.chartOptions.hAxis.titleTextStyle.fontSize;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-italic').on('change', function () {
				_this.chartOptions.hAxis.textStyle.italic = $(this).is(':checked');
				_this.chartSourceData.settings.haxis_italic = _this.chartOptions.hAxis.textStyle.italic ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-bold').on('change', function () {
				_this.chartOptions.hAxis.textStyle.bold = $(this).is(':checked');
				_this.chartSourceData.settings.haxis_bold = _this.chartOptions.hAxis.textStyle.bold ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-title-italic').on('change', function () {
				_this.chartOptions.hAxis.titleTextStyle.italic = $(this).is(':checked');
				_this.chartSourceData.settings.haxis_title_italic = _this.chartOptions.hAxis.titleTextStyle.italic ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-title-bold').on('change', function () {
				_this.chartOptions.hAxis.titleTextStyle.bold = $(this).is(':checked');
				_this.chartSourceData.settings.haxis_title_bold = _this.chartOptions.hAxis.titleTextStyle.bold ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-label-color').on('input', function () {
				_this.chartOptions.hAxis.titleTextStyle.color = $(this).val();
				_this.chartSourceData.settings.haxis_label_color = _this.chartOptions.hAxis.titleTextStyle.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-max-value').on('input', function () {
				_this.chartOptions.hAxis.viewWindow.max = $(this).val();
				_this.chartSourceData.settings.haxis_max_value = _this.chartOptions.hAxis.viewWindow.max;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-min-value').on('input', function () {
				_this.chartOptions.hAxis.viewWindow.min = $(this).val();
				_this.chartSourceData.settings.haxis_min_value = _this.chartOptions.hAxis.viewWindow.min;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-gridlines-count').on('input', function () {
				_this.chartOptions.hAxis.gridlines.count = $(this).val();
				_this.chartSourceData.settings.haxis_gridlines_count = _this.chartOptions.hAxis.gridlines.count;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-gridlines-color').on('input', function () {
				_this.chartOptions.hAxis.gridlines.color = $(this).val();
				_this.chartSourceData.settings.haxis_gridlines_color = _this.chartOptions.hAxis.gridlines.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-minor-gridlines-color').on('input', function () {
				_this.chartOptions.hAxis.minorGridlines.color = $(this).val();
				_this.chartSourceData.settings.haxis_minor_gridlines_color = _this.chartOptions.hAxis.minorGridlines.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

		// vertical axis settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-title').on('input', function () {
				_this.chartOptions.vAxis.title = $(this).val();
				_this.chartSourceData.settings.vaxis_title = _this.chartOptions.vAxis.title;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-text-position').on('change', function () {
				_this.chartOptions.vAxis.textPosition = $(this).val();
				_this.chartSourceData.settings.vaxis_text_position = _this.chartOptions.vAxis.textPosition;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-text-direction').on('change', function () {
				_this.chartOptions.vAxis.direction = $(this).is(':checked') ? -1 : 1;
				_this.chartSourceData.settings.vaxis_text_direction = _this.chartOptions.vAxis.direction;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-text-color').on('input', function () {
				_this.chartOptions.vAxis.textStyle.color = $(this).val();
				_this.chartSourceData.settings.vaxis_text_color = _this.chartOptions.vAxis.textStyle.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-baseline-color').on('input', function () {
				_this.chartOptions.vAxis.baselineColor = $(this).val();
				_this.chartSourceData.settings.vaxis_baseline_color = _this.chartOptions.vAxis.baselineColor;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-text-font-size').on('input', function () {
				_this.chartOptions.vAxis.textStyle.fontSize = $(this).val();
				_this.chartSourceData.settings.vaxis_text_font_size = _this.chartOptions.vAxis.textStyle.fontSize;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-format').on('change', function () {
				_this.chartOptions.vAxis.format = $(this).val();
				_this.chartSourceData.settings.vaxis_format = _this.chartOptions.vAxis.format;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-label-font-size').on('input', function () {
				_this.chartOptions.vAxis.titleTextStyle.fontSize = $(this).val();
				_this.chartSourceData.settings.vaxis_label_font_size = _this.chartOptions.vAxis.titleTextStyle.fontSize;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-italic').on('change', function () {
				_this.chartOptions.vAxis.textStyle.italic = $(this).is(':checked');
				_this.chartSourceData.settings.vaxis_italic = _this.chartOptions.vAxis.textStyle.italic ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-bold').on('change', function () {
				_this.chartOptions.vAxis.textStyle.bold = $(this).is(':checked');
				_this.chartSourceData.settings.vaxis_bold = _this.chartOptions.vAxis.textStyle.bold ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-title-italic').on('change', function () {
				_this.chartOptions.vAxis.titleTextStyle.italic = $(this).is(':checked');
				_this.chartSourceData.settings.vaxis_title_italic = _this.chartOptions.vAxis.titleTextStyle.italic ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-title-bold').on('change', function () {
				_this.chartOptions.vAxis.titleTextStyle.bold = $(this).is(':checked');
				_this.chartSourceData.settings.vaxis_title_bold = _this.chartOptions.vAxis.titleTextStyle.bold ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-label-color').on('input', function () {
				_this.chartOptions.vAxis.titleTextStyle.color = $(this).val();
				_this.chartSourceData.settings.vaxis_label_color = _this.chartOptions.vAxis.titleTextStyle.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-max-value').on('input', function () {
				_this.chartOptions.vAxis.viewWindow.max = $(this).val();
				_this.chartSourceData.settings.vaxis_max_value = _this.chartOptions.vAxis.viewWindow.max;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-min-value').on('input', function () {
				_this.chartOptions.vAxis.viewWindow.min = $(this).val();
				_this.chartSourceData.settings.vaxis_min_value = _this.chartOptions.vAxis.viewWindow.min;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-gridlines-count').on('input', function () {
				_this.chartOptions.vAxis.gridlines.count = $(this).val();
				_this.chartSourceData.settings.vaxis_gridlines_count = _this.chartOptions.vAxis.gridlines.count;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-gridlines-color').on('input', function () {
				_this.chartOptions.vAxis.gridlines.color = $(this).val();
				_this.chartSourceData.settings.vaxis_gridlines_color = _this.chartOptions.vAxis.gridlines.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-minor-gridlines-color').on('input', function () {
				_this.chartOptions.vAxis.minorGridlines.color = $(this).val();
				_this.chartSourceData.settings.vaxis_minor_gridlines_color = _this.chartOptions.vAxis.minorGridlines.color;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

		// animation settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-animation').on('change', function () {
				if ($(this).is(':checked')) {
					_this.chartOptions.animation = {
						startup: _this.$el.find('#'+_this.htmlClassPrefix+'option-animation-startup').is(':checked'),
						duration: _this.$el.find('#'+_this.htmlClassPrefix+'option-animation-duration').val(),
						easing: _this.$el.find('#'+_this.htmlClassPrefix+'option-animation-easing').val(),
					}
					_this.chartSourceData.settings.enable_animation = 'checked';
				} else {
					delete _this.chartOptions.animation;
					_this.chartSourceData.settings.enable_animation = '';
				}
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-animation-duration').on('input', function () {
				if (_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-animation').is(':checked')) {
					_this.chartOptions.animation.duration = $(this).val();
					_this.chartSourceData.settings.animation_duration = _this.chartOptions.animation.duration;
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-animation-startup').on('input', function () {
				if (_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-animation').is(':checked')) {
					_this.chartOptions.animation.startup = $(this).is(':checked');
					_this.chartSourceData.settings.animation_startup = _this.chartOptions.animation.startup ? 'checked' : '';
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-animation-easing').on('input', function () {
				if (_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-animation').is(':checked')) {
					_this.chartOptions.animation.easing = $(this).val();
					_this.chartSourceData.settings.animation_easing = _this.chartOptions.animation.easing;
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});

		// advanced settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-rotation-degree').on('input', function () {
				_this.chartOptions.pieStartAngle = $(this).val();
				_this.chartSourceData.settings.rotation_degree = _this.chartOptions.pieStartAngle;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-reverse-categories').on('change', function () {
				_this.chartOptions.reverseCategories = $(this).is(':checked');
				_this.chartSourceData.settings.reverse_categories = _this.chartOptions.reverseCategories ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-slice-border-color').on('input', function () {
				_this.chartOptions.pieSliceBorderColor = $(this).val();
				_this.chartSourceData.settings.slice_border_color = _this.chartOptions.pieSliceBorderColor;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-slice-text').on('change', function () {
				_this.chartOptions.pieSliceText = $(this).val();
				_this.chartSourceData.settings.slice_text = _this.chartOptions.pieSliceText;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-is-stacked').on('change', function () {
				_this.chartOptions.isStacked = $(this).is(':checked');
				_this.chartSourceData.settings.is_stacked = _this.chartOptions.isStacked ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-focus-target').on('change', function () {
				_this.chartOptions.focusTarget = $(this).val();
				_this.chartSourceData.settings.focus_target = _this.chartOptions.focusTarget;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-opacity').on('input', function () {
				_this.chartOptions.dataOpacity = $(this).val();
				_this.chartSourceData.settings.opacity = _this.chartOptions.dataOpacity;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-tooltip-text').on('change', function () {
				_this.chartOptions.tooltip.text = $(this).val();
				_this.chartSourceData.settings.tooltip_text = _this.chartOptions.tooltip.text;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-line-width').on('input', function () {
				_this.chartOptions.lineWidth = $(this).val();
				_this.chartSourceData.settings.line_width = _this.chartOptions.lineWidth;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-data-grouping-limit').on('input', function () {
				_this.chartOptions.sliceVisibilityThreshold = $(this).val()/100;
				_this.chartSourceData.settings.data_grouping_limit = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-data-grouping-label').on('input', function () {
				_this.chartOptions.pieResidueSliceLabel = $(this).val();
				_this.chartSourceData.settings.data_grouping_label = _this.chartOptions.pieResidueSliceLabel;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-data-grouping-color').on('input', function () {
				_this.chartOptions.pieResidueSliceColor = $(this).val();
				_this.chartSourceData.settings.data_grouping_color = _this.chartOptions.pieResidueSliceColor;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-multiple-selection').on('change', function () {
				_this.chartOptions.selectionMode = $(this).is(':checked') ? 'multiple' : 'single';
				_this.chartSourceData.settings.multiple_selection = $(this).is(':checked') ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-multiple-data-format').on('change', function () {
				_this.chartOptions.aggregationTarget = $(this).val();
				_this.chartSourceData.settings.multiple_data_format = _this.chartOptions.aggregationTarget;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-point-shape').on('change', function () {
				_this.chartOptions.pointShape = $(this).val();
				_this.chartSourceData.settings.point_shape = _this.chartOptions.pointShape;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-point-size').on('input', function () {
				_this.chartOptions.pointSize = $(this).val();
				_this.chartSourceData.settings.point_size = _this.chartOptions.pointSize;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-crosshair-trigger').on('change', function () {
				_this.chartOptions.crosshair.trigger = $(this).val();
				_this.chartSourceData.settings.crosshair_trigger = _this.chartOptions.crosshair.trigger;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-crosshair-orientation').on('change', function () {
				_this.chartOptions.crosshair.orientation = $(this).val();
				_this.chartSourceData.settings.crosshair_orientation = _this.chartOptions.crosshair.orientation;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-crosshair-opacity').on('input', function () {
				_this.chartOptions.crosshair.opacity = $(this).val();
				_this.chartSourceData.settings.crosshair_opacity = _this.chartOptions.crosshair.opacity;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-group-width').on('input', function () {
				var format = _this.$el.find('#'+_this.htmlClassPrefix+'option-group-width-format').val() == '%' ? '%' : '';
				_this.chartOptions.bar.groupWidth = $(this).val() + format;
				_this.chartSourceData.settings.group_width = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-group-width-format').on('change', function () {
				var format = '%';
				if ($(this).val() == 'px') {
					format = '';
				}
				var value = _this.$el.find('#'+_this.htmlClassPrefix+'option-group-width').val();
				_this.chartOptions.bar.groupWidth = value + format;
				_this.chartSourceData.settings.group_width_format = format;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-orientation').on('change', function () {
				_this.chartOptions.orientation = $(this).is(':checked') ? 'vertical' : 'horizontal';
				_this.chartSourceData.settings.orientation = $(this).is(':checked') ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-fill-nulls').on('change', function () {
				_this.chartOptions.interpolateNulls = $(this).is(':checked') ? 'true' : 'false';
				_this.chartSourceData.settings.full_nulls = $(this).is(':checked') ? 'checked' : '';
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-line-curve-type').on('change', function () {
				_this.chartOptions.curveType = $(this).val();
				_this.chartSourceData.settings.line_curve_type = _this.chartOptions.curveType;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-donut-hole-size').on('input', function () {
				_this.chartOptions.pieHole = $(this).val();
				_this.chartSourceData.settings.donut_hole_size = _this.chartOptions.pieHole;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-chart-font-size').on('change', function () {
				_this.chartOptions.size = $(this).val();
				_this.chartSourceData.settings.org_chart_font_size = _this.chartOptions.size;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-show-scale').on('change', function () {
				_this.chartOptions.showScale = $(this).is(':checked');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-min-color').on('input', function () {
				_this.chartOptions.minColor = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-max-color').on('input', function () {
				_this.chartOptions.maxColor = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-max-font-size').on('input', function () {
				_this.chartOptions.maxFontSize = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-sankey-link-color').on('input', function () {
				_this.chartOptions.sankey.link.color.fill = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-sankey-border-color').on('input', function () {
				_this.chartOptions.sankey.link.color.stroke = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-sankey-border-width').on('input', function () {
				_this.chartOptions.sankey.link.color.strokeWidth = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-percent-enabled').on('change', function () {
				_this.chartOptions.gantt.percentEnabled = $(this).is(':checked');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-show-row-labels').on('change', function () {
				_this.chartOptions.timeline.showRowLabels = $(this).is(':checked');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-timeline-single-color').on('change', function () {
				var angleOption = _this.$el.find('#'+_this.htmlClassPrefix+'option-timeline-color');
				if ($(this).is(':checked')) {
					angleOption.parents('.'+_this.htmlClassPrefix+'options-section').removeClass('display_none');
					_this.chartOptions.timeline.singleColor = angleOption.val()
				} else {
					angleOption.parents('.'+_this.htmlClassPrefix+'options-section').addClass('display_none');
					delete _this.chartOptions.timeline.singleColor;
				}
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-timeline-color').on('input', function () {
				if (_this.$el.find('#'+_this.htmlClassPrefix+'option-timeline-single-color').is(':checked')) {
					_this.chartOptions.timeline.singleColor = $(this).val();
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-allow-collapse').on('change', function () {
				_this.chartOptions.allowCollapse = $(this).is(':checked');
				_this.chartSourceData.settings.allow_collapse = _this.chartOptions.allowCollapse;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-classname').on('input', function () {
				_this.chartOptions.nodeClass = $(this).val();
				_this.chartSourceData.settings.org_classname = _this.chartOptions.nodeClass;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-node-background-color').on('input', function () {
				var orgClassname = _this.chartSourceData.settings.org_classname;
				_this.chartSourceData.settings.org_node_background_color = $(this).val();
				if (orgClassname != '') {
					_this.setOrgChartCustomStyles();
				}
			});
				
			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-node-padding').on('input', function () {
				var orgClassname = _this.chartSourceData.settings.org_classname;
				_this.chartSourceData.settings.org_node_padding = $(this).val();
				if (orgClassname != '') {
					_this.setOrgChartCustomStyles();
				}
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-node-border-radius').on('input', function () {
				var orgClassname = _this.chartSourceData.settings.org_classname;
				_this.chartSourceData.settings.org_node_border_radius = $(this).val();
				if (orgClassname != '') {
					_this.setOrgChartCustomStyles();
				}
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-node-border-width').on('input', function () {
				var orgClassname = _this.chartSourceData.settings.org_classname;
				_this.chartSourceData.settings.org_node_border_width = $(this).val();
				if (orgClassname != '') {
					_this.setOrgChartCustomStyles();
				}
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-node-border-color').on('input', function () {
				var orgClassname = _this.chartSourceData.settings.org_classname;
				_this.chartSourceData.settings.org_node_border_color = $(this).val();
				if (orgClassname != '') {
					_this.setOrgChartCustomStyles();
				}
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-node-text-color').on('input', function () {
				var orgClassname = _this.chartSourceData.settings.org_classname;
				_this.chartSourceData.settings.org_node_text_color = $(this).val();
				if (orgClassname != '') {
					_this.setOrgChartCustomStyles();
				}
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-node-text-font-size').on('input', function () {
				var orgClassname = _this.chartSourceData.settings.org_classname;
				_this.chartSourceData.settings.org_node_text_font_size = $(this).val();
				if (orgClassname != '') {
					_this.setOrgChartCustomStyles();
				}
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-node-description-font-color').on('input', function () {
				_this.chartSourceData.settings.org_node_description_font_color = $(this).val();
				_this.setOrgChartCustomStyles();
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-org-node-description-font-size').on('input', function () {
				_this.chartSourceData.settings.org_node_description_font_size = $(this).val();
				_this.setOrgChartCustomStyles();
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-sort-column-index').on('input', function () {
				_this.chartOptions.sortColumn = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-show-row-number').on('change', function () {
				_this.chartOptions.showRowNumber = $(this).is(':checked');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-max-font-size').on('input', function () {
				_this.chartOptions.maxFontSize = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-sankey-link-color').on('input', function () {
				_this.chartOptions.sankey.link.color.fill = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-sankey-border-color').on('input', function () {
				_this.chartOptions.sankey.link.color.stroke = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-sankey-border-width').on('input', function () {
				_this.chartOptions.sankey.link.color.strokeWidth = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-percent-enabled').on('change', function () {
				_this.chartOptions.gantt.percentEnabled = $(this).is(':checked');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-show-row-labels').on('change', function () {
				_this.chartOptions.timeline.showRowLabels = $(this).is(':checked');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-timeline-single-color').on('change', function () {
				var angleOption = _this.$el.find('#'+_this.htmlClassPrefix+'option-timeline-color');
				if ($(this).is(':checked')) {
					angleOption.parents('.'+_this.htmlClassPrefix+'options-section').removeClass('display_none');
					_this.chartOptions.timeline.singleColor = angleOption.val()
				} else {
					angleOption.parents('.'+_this.htmlClassPrefix+'options-section').addClass('display_none');
					delete _this.chartOptions.timeline.singleColor;
				}
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-timeline-color').on('input', function () {
				if (_this.$el.find('#'+_this.htmlClassPrefix+'option-timeline-single-color').is(':checked')) {
					_this.chartOptions.timeline.singleColor = $(this).val();
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-allow-collapse').on('change', function () {
				_this.chartOptions.allowCollapse = $(this).is(':checked');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-minor-ticks').on('input', function () {
				_this.chartOptions.minorTicks = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-keep-aspect-ratio').on('change', function () {
				_this.chartOptions.keepAspectRatio = $(this).is(':checked');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-sort-column-index').on('input', function () {
				_this.chartOptions.sortColumn = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-show-row-number').on('change', function () {
				_this.chartOptions.showRowNumber = $(this).is(':checked');
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

		// Slices settings
			_this.$el.find('.'+_this.htmlClassPrefix+'option-slice-color').on('input', function () {
				var id = $(this).attr('data-slice-id');
				_this.chartOptions.slices[id].color = $(this).val();
				_this.chartSourceData.settings.slice_color[id] = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('.'+_this.htmlClassPrefix+'option-slice-offset').on('input', function () {
				var id = $(this).attr('data-slice-id');
				_this.chartOptions.slices[id].offset = $(this).val();
				_this.chartSourceData.settings.slice_offset[id] = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('.'+_this.htmlClassPrefix+'option-slice-text-color').on('input', function () {
				var id = $(this).attr('data-slice-id');
				_this.chartOptions.slices[id].textStyle.color = $(this).val();
				_this.chartSourceData.settings.slice_text_color[id] = $(this).val();
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});
			
		// Series settings
			_this.$el.find('.'+_this.htmlClassPrefix+'option-series-color').on('input', function () {
				if (!_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-row-settings').is(':checked')) {
					var id = $(this).attr('data-series-id');
					_this.chartOptions.series[id].color = $(this).val();
					_this.chartSourceData.settings.series_color[id] = $(this).val();
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});
			
			_this.$el.find('.'+_this.htmlClassPrefix+'option-series-visible-in-legend').on('input', function () {
				// if (!_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-row-settings').is(':checked')) {
				if (_this.chartSourceData.source[0].length > 2) {
					var id = $(this).attr('data-series-id');
					_this.chartOptions.series[id].visibleInLegend = $(this).is(':checked');
					_this.chartSourceData.settings.series_visible_in_legend[id] = $(this).val();
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
				// }
			});

		// Rows settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-row-settings').on('change', function () {
				var getChartSource = _this.chartSourceData.source;
				var dataTypes = _this.multiColumnChartConvertData( getChartSource );
					
				if ($(this).is(':checked')) {
					dataTypes = _this.setRowOptions(dataTypes, _this.chartSourceData.settings, false);
					_this.chartSourceData.settings.enable_row_settings = 'checked';
				} else {
					dataTypes = _this.removeRowOptions(dataTypes);
					_this.chartSourceData.settings.enable_row_settings = '';
				}

				_this.chartData = google.visualization.arrayToDataTable(dataTypes);
				_this.chartDataArray = dataTypes;
				_this.drawChartFunction(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('.'+_this.htmlClassPrefix+'option-rows-color').on('input', function () {
				if (_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-row-settings').is(':checked')) {
					var getChartSource = _this.chartSourceData.source;
					var dataTypes = _this.multiColumnChartConvertData( getChartSource );
					
					var id = $(this).attr('data-rows-id');
					_this.chartSourceData.settings.rows_color[id] = $(this).val();
	
					dataTypes = _this.setRowOptions(dataTypes, _this.chartSourceData.settings, false);
		
					_this.chartData = google.visualization.arrayToDataTable(dataTypes);
					_this.chartDataArray = dataTypes;
	
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});
			
			_this.$el.find('.'+_this.htmlClassPrefix+'option-rows-opacity').on('input', function () {
				if (_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-row-settings').is(':checked')) {
					var getChartSource = _this.chartSourceData.source;
					var dataTypes = _this.multiColumnChartConvertData( getChartSource );
					
					var id = $(this).attr('data-rows-id');
					_this.chartSourceData.settings.rows_opacity[id] = $(this).val();
	
					dataTypes = _this.setRowOptions(dataTypes, _this.chartSourceData.settings, false);
		
					_this.chartData = google.visualization.arrayToDataTable(dataTypes);
					_this.chartDataArray = dataTypes;
	
					_this.drawChartFunction(_this.chartData, _this.chartOptions);
				}
			});
	}

	AysChartBuilder.prototype.toggleExternalDatabaseSpecificSettings = function (e) {
		var target = e.target;
		var externalDatabaseSettings = $(document).find('.ays-external-db-custom-settings');

		if ($(target).is(':checked')) {
			externalDatabaseSettings.show();
		} else {
			externalDatabaseSettings.hide();
		}
	}

	AysChartBuilder.prototype.toggleGeoUrl = function (e) {
		var _this = this;

		var title = _this.$el.find('.ays-chart-url-box .ays-chart-chart-source-title-input');
		var inputs = _this.$el.find('.ays-chart-chart-source-data-input-url input[type="text"]');
		
		if (title.prop("readonly") && inputs.prop("readonly")) {
			title.prop( "readonly", false );
			inputs.prop( "readonly", false );
		} else {
			title.prop( "readonly", true );
			inputs.prop( "readonly", true );
		}
	}

	AysChartBuilder.prototype.toggleQuizSelect = function (e) {
		var _this = this;

		var select = _this.$el.find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query');
		var option = $(select).find('option:selected').val();
		var selectQuizSelect = _this.$el.find('#'+_this.htmlClassPrefix+'quiz-quizes');
		var selectQuizCatSelect = _this.$el.find('#'+_this.htmlClassPrefix+'quiz-categories');
		var selectQuizQuestionCatSelect = _this.$el.find('#'+_this.htmlClassPrefix+'quiz-question-categories');

		if (option == 'q1' || option == 'q3' || option == 'q6' || option == 'q9' || option == 'q10' || option == 'q11' || option == 'q12' || option == 'q13') {
			selectQuizSelect.slideDown();
		} else {
			selectQuizSelect.slideUp();
		}
		if (option == 'q7' || option == 'q8') {
			selectQuizCatSelect.slideDown();
		} else {
			selectQuizCatSelect.slideUp();
		}
		if (option == 'q13') {
			selectQuizQuestionCatSelect.slideDown();
		} else {
			selectQuizQuestionCatSelect.slideUp();
		}
	}

	AysChartBuilder.prototype.quizMakerIntegrationConfig = function (e) {
		var _this = this;

		var input = $(document).find('input[name="ays_source_type"]');
		if (input.val() !== 'quiz_maker') input.val('quiz_maker');

		_this.$el.find('.ays-chart-quiz-maker-success').empty();
		_this.$el.find('.ays-chart-quiz-maker-error').empty();
	}

	AysChartBuilder.prototype.woocommerceIntegrationConfig = function (e) {
		var _this = this;

		var input = $(document).find('input[name="ays_source_type"]');
		if (input.val() !== 'woocommerce_data') input.val('woocommerce_data');

		_this.$el.find('.ays-chart-woocommerce-datas-success').empty();
		_this.$el.find('.ays-chart-woocommerce-datas-error').empty();
	}

	AysChartBuilder.prototype.detectManualChange = function (e) {
		var input = $(document).find('input[name="ays_source_type"]');
		if (input.val() !== 'manual') input.val('manual'); 	
	}

	// Disabling submit when pressing enter button on input
	AysChartBuilder.prototype.disableSubmit = function(e){
		if (e.which == 13) {
			if ($(document).find("#ays-charts-form").length !== 0 || $(document).find("#ays-settings-form").length !== 0) {
				var parent = $(e.target).parents('.ays-chart-chart-source-data-edit-block');
				var index = $(e.target).parents('.ays-chart-chart-source-data-input-box').index();
				index = parent.index() == 0 ? index - 1 : index - 2;

				var nextRow;
				if (parent.next('.ays-chart-chart-source-data-edit-block').length > 0) {
					nextRow = parent.next('.ays-chart-chart-source-data-edit-block');
				} else {
					nextRow = parent.parents('.ays-chart-chart-source-data-content').find('.ays-chart-chart-source-data-edit-block').eq(0);
				}

				nextRow.children('.ays-chart-chart-source-data-input-box').eq(index).find('.ays-text-input').focus();

				return false;
			}
		}
	}

	// Change tabs (tabulation)
	AysChartBuilder.prototype.changeTabs = function(e){
		if(! $(this).hasClass('no-js')){
			var elemenetID = $(this).attr('href');
			var active_tab = $(this).attr('data-tab');
			$(document).find('.nav-tab-wrapper a.nav-tab').each(function () {
				if ($(this).hasClass('nav-tab-active')) {
					$(this).removeClass('nav-tab-active');
				}
			});
			$(this).addClass('nav-tab-active');
			$(document).find('.ays-tab-content').each(function () {
				$(this).removeClass('ays-tab-content-active');
			});
			$(document).find("[name='ays_chart_tab']").val(active_tab);
			$('.ays-tab-content' + elemenetID).addClass('ays-tab-content-active');
			e.preventDefault();
		}
	}

	AysChartBuilder.prototype.changeCurrentUrl = function(key){
		var linkModified = location.href.split('?')[1].split('&');
		for(var i = 0; i < linkModified.length; i++){
			if(linkModified[i].split("=")[0] == key){
				linkModified.splice(i, 1);
			}
		}
		linkModified = linkModified.join('&');
		window.history.replaceState({}, document.title, '?'+linkModified);
	}

	AysChartBuilder.prototype.toggleDDmenu = function(e){
		var ddmenu = $(this).next();
		var state = ddmenu.attr('data-expanded');
		switch (state) {
			case 'true':
				$(this).find('.ays_fa').css({
					transform: 'rotate(0deg)'
				});
				ddmenu.attr('data-expanded', 'false');
				break;
			case 'false':
				$(this).find('.ays_fa').css({
					transform: 'rotate(90deg)'
				});
				ddmenu.attr('data-expanded', 'true');
				break;
		}
	}

	AysChartBuilder.prototype.submitOnce = function(el) {
        setTimeout(function() {
			$(document).find('.ays-chart-loader-banner').attr('disabled', true);
        }, 50);

        setTimeout(function() {
            $(document).find('.ays-chart-loader-banner').attr('disabled', false);
        }, 5000);
	}

	// Load charts by given type main function
	AysChartBuilder.prototype.initLibraries = function (){
		var _this = this;

		var googleSelect = _this.$el.find('.' + _this.htmlClassPrefix + 'google-sheet-select');
		googleSelect.select2();
		var fileTypeSelect =  _this.$el.find('#' + _this.htmlClassPrefix + 'import-files-file-type');
		fileTypeSelect.select2();
		var quizQuerySelect =  _this.$el.find('#' + _this.htmlClassPrefix + 'select-quiz-maker-data-query');
		quizQuerySelect.select2();
		var quizQuizSelect =  _this.$el.find('#' + _this.htmlClassPrefix + 'select-quiz-maker-quiz');
		quizQuizSelect.select2();
		var quizCatSelect =  _this.$el.find('#' + _this.htmlClassPrefix + 'select-quiz-maker-quiz-category');
		quizCatSelect.select2();
		var quizQuestionCatSelect =  _this.$el.find('#' + _this.htmlClassPrefix + 'select-quiz-maker-question-category');
		quizQuestionCatSelect.select2();
		var woocommerceSelect =  _this.$el.find('#' + _this.htmlClassPrefix + 'woocommerce-datas-select');
		woocommerceSelect.select2();

		_this.$el.find('#ays-chart-option-create-author').select2({
			placeholder: aysChartBuilderAdmin.selectUser,
			minimumInputLength: 1,
			allowClear: true,
			language: {
				searching: function() {
					return aysChartBuilderAdmin.searching;
				},
				inputTooShort: function () {
					return aysChartBuilderAdmin.pleaseEnterMore;
				}
			},
			ajax: {
				url: ajaxurl,
				dataType: 'json',
				data: function (response) {
					var checkedUsers = _this.$el.find('#ays-chart-option-create-author').val();
					return {
						action: _this.ajaxAction,
						function: window.aysChartBuilderChartSettings.ajax['actions']['author_user_search'],
						security: window.aysChartBuilderChartSettings.ajax['nonces']['author_user_search'],
						params: {
							search: response.term,
							val: checkedUsers
						}
					};
				}
			}
		});

		_this.$el.find('.' + _this.htmlClassPrefix + 'chart-source-data-content').sortable({
			items: "> div." + _this.htmlClassPrefix + "chart-source-data-edit-block:not(:first)",
			handle: "." + _this.htmlClassPrefix + "chart-source-data-move-row",
            update: function (event, ui) {
                _this.$el.find('div.' + _this.htmlClassPrefix + 'chart-source-data-edit-block:not(:first)').each(function (index) {
					$(this).attr('data-source-id', index + 1);
					$(this).find("input.ays-text-input").attr('name', 'ays_chart_source_data[' + (index + 1) + '][]')
                });
            }
		});

		$(document).find('.' + _this.htmlClassPrefix + 'gsheet-columns-sortable').sortable({
			cursor: 'move',
            opacity: 0.8,
            tolerance: "pointer",
            helper: "clone",
            placeholder: "ays_gsheet_columns_sortable_placeholder",
            revert: true,
            forcePlaceholderSize: true,
            forceHelperSize: true,
		});

	}

	// Load charts by given type main function
	AysChartBuilder.prototype.loadChartBySource = function(isChangedType = false){
		var _this = this;

		if( ! _this.chartType ){
			_this.chartType = _this.chartSourceData.chartType;
		}

		if(typeof _this.chartType !== undefined && _this.chartType){
			switch (_this.chartType) {
				case 'pie_chart':
					_this.pieChartView(isChangedType);
					break;
				case 'bar_chart':
					_this.barChartView(isChangedType);
					break;
				case 'column_chart':
					_this.columnChartView(isChangedType);
					break;
				case 'line_chart':
					_this.lineChartView(isChangedType);
					break;
				case 'donut_chart':
					_this.donutChartView(isChangedType);
					break;
				case 'histogram':
					_this.histogramView(isChangedType);
					break;
				case 'geo_chart':
					_this.geoChartView(isChangedType);
					break;
				case 'org_chart':
					_this.orgChartView(isChangedType);
					break;
				case 'area_chart':
					_this.areaChartView(isChangedType);
					break;
				case 'gauge_chart':
					_this.gaugeChartView(isChangedType);
					break;
				case 'combo_chart':
					_this.comboChartView(isChangedType);
					break;
				case 'stepped_area_chart':
					_this.steppedAreaChartView(isChangedType);
					break;
				case 'bubble_chart':
					_this.bubbleChartView(isChangedType);
					break;
				case 'scatter_chart':
					_this.scatterChartView(isChangedType);
					break;
				case 'table_chart':
					_this.tableChartView(isChangedType);
					break;
				case 'timeline_chart':
					_this.timelineChartView(isChangedType);
					break;
				case 'candlestick_chart':
					_this.candlestickChartView(isChangedType);
					break;
				case 'gantt_chart':
					_this.ganttChartView(isChangedType);
					break;
				case 'sankey_diagram':
					_this.sankeyDiagramView(isChangedType);
					break;
				case 'treemap':
					_this.treemapView(isChangedType);
					break;
				case 'word_tree':
					_this.wordTreeChartView(isChangedType);
					break;
				case '3dpie_chart':
					_this.pie3DChartView(isChangedType);
					break;
				default:
					_this.pieChartView(isChangedType);
					break;
			}
		}		
	}

	// Load chart by pie chart
	AysChartBuilder.prototype.pieChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;

		var dataTypes = _this.chartConvertData( getChartSource );

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);
		
		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = isChangedType ? _this.chartData : google.visualization.arrayToDataTable( dataTypes );

			_this.chartOptions = {
				fontSize: nSettings.chartFontSize,
				chartArea: {
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				enableInteractivity: nSettings.enableInteractivity,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					text: nSettings.tooltipText,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				pieStartAngle: nSettings.rotationDegree,
				pieSliceBorderColor: nSettings.sliceBorderColor,
				reverseCategories: nSettings.reverseCategories,
				pieSliceText: nSettings.sliceText,
				sliceVisibilityThreshold: nSettings.dataGroupingLimit,
				pieResidueSliceLabel: nSettings.dataGroupingLabel,
				pieResidueSliceColor: nSettings.dataGroupingColor,
				slices: {}
			};

			for (var i = 0; i < dataTypes.length - 1; i++) {
				_this.chartOptions.slices[i] = {
					color: nSettings.sliceColor[i],
					offset: typeof nSettings.sliceOffset[i] !== 'undefined' ? nSettings.sliceOffset[i] : 0,
					textStyle: {
						color: nSettings.sliceTextColor[i],
					},
				}
			}

			_this.chartObj = new google.visualization.PieChart( document.getElementById(_this.htmlClassPrefix + _this.chartType) );

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by bar chart
	AysChartBuilder.prototype.barChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.multiColumnChartConvertData( getChartSource );

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);
		
		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = nSettings.enableRowSettings ? _this.setRowOptions(dataTypes, nSettings, true) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.chartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				enableInteractivity: nSettings.enableInteractivity,
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					direction: nSettings.hAxisDirection,
					baselineColor: nSettings.hAxisBaselineColor,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic: nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
					minorGridlines: {
						color: nSettings.hAxisMinorGridlinesColor,
					},
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					direction: nSettings.vAxisDirection,
					baselineColor: nSettings.vAxisBaselineColor,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
					minorGridlines: {
						color: nSettings.vAxisMinorGridlinesColor,
					},
				},
				focusTarget: nSettings.focusTarget,
				isStacked: nSettings.isStacked,
				dataOpacity: nSettings.opacity,
				bar: {
					groupWidth: nSettings.groupWidth
				},
				series: {},
			};

			for (var i = 0; i < dataTypes[0].length; i++) {
				_this.chartOptions.series[i] = {
					color: nSettings.seriesColor[i],
					visibleInLegend: nSettings.seriesVisibleInLegend[i] == 'on' ? true : (typeof nSettings.seriesColor[i] !== 'undefined' ? false : true),
				}
			}

			if (nSettings.enableAnimation) {
				_this.chartOptions.animation = {
					startup: nSettings.animationStartup,
					duration: nSettings.animationDuration,
					easing: nSettings.animationEasing,
				}
			}

			_this.chartObj = new google.visualization.BarChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by column chart
	AysChartBuilder.prototype.columnChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;

		var dataTypes = _this.multiColumnChartConvertData( getChartSource );

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = nSettings.enableRowSettings ? _this.setRowOptions(dataTypes, nSettings, true) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.chartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				enableInteractivity: nSettings.enableInteractivity,
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					direction: nSettings.hAxisDirection,
					baselineColor: nSettings.hAxisBaselineColor,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic: nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
					minorGridlines: {
						color: nSettings.hAxisMinorGridlinesColor,
					},
					showTextEvery: nSettings.hAxisShowTextEvery
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					direction: nSettings.vAxisDirection,
					baselineColor: nSettings.vAxisBaselineColor,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
					minorGridlines: {
						color: nSettings.vAxisMinorGridlinesColor,
					},
				},
				focusTarget: nSettings.focusTarget,
				isStacked: nSettings.isStacked,
				dataOpacity: nSettings.opacity,
				bar: {
					groupWidth: nSettings.groupWidth
				},
				series: {},
			};

			for (var i = 0; i < dataTypes[0].length; i++) {
				_this.chartOptions.series[i] = {
					color: nSettings.seriesColor[i],
					visibleInLegend: nSettings.seriesVisibleInLegend[i] == 'on' ? true : (typeof nSettings.seriesColor[i] !== 'undefined' ? false : true),
				}
			}

			if (nSettings.enableAnimation) {
				_this.chartOptions.animation = {
					startup: nSettings.animationStartup,
					duration: nSettings.animationDuration,
        			easing: nSettings.animationEasing,
				}
			}

			_this.chartObj = new google.visualization.ColumnChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by line chart
	AysChartBuilder.prototype.lineChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.multiColumnChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = nSettings.enableRowSettings ? _this.setRowOptions(dataTypes, nSettings, true) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.chartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				enableInteractivity: nSettings.enableInteractivity,
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					direction: nSettings.hAxisDirection,
					baselineColor: nSettings.hAxisBaselineColor,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic: nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
					minorGridlines: {
						color: nSettings.hAxisMinorGridlinesColor,
					},
					showTextEvery: nSettings.hAxisShowTextEvery
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					direction: nSettings.vAxisDirection,
					baselineColor: nSettings.vAxisBaselineColor,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
					minorGridlines: {
						color: nSettings.vAxisMinorGridlinesColor,
					},
				},
				crosshair: {
					opacity: nSettings.crosshairOpacity,
					orientation: nSettings.crosshairOrientation,
					trigger: nSettings.crosshairTrigger,
				},
				focusTarget: nSettings.focusTarget,
				dataOpacity: nSettings.opacity,
				lineWidth: nSettings.lineWidth,
				selectionMode: nSettings.multipleSelection,
				aggregationTarget: nSettings.multipleDataFormat,
				pointShape: nSettings.pointShape,
				pointSize: nSettings.pointSize,
				orientation: nSettings.orientation,
				interpolateNulls: nSettings.fillNulls,
				curveType: nSettings.curveType,
				series: {},
			};

			for (var i = 0; i < dataTypes[0].length; i++) {
				_this.chartOptions.series[i] = {
					color: nSettings.seriesColor[i],
					visibleInLegend: nSettings.seriesVisibleInLegend[i] == 'on' ? true : (typeof nSettings.seriesColor[i] !== 'undefined' ? false : true),
				}
			}

			if (nSettings.enableAnimation) {
				_this.chartOptions.animation = {
					startup: nSettings.animationStartup,
					duration: nSettings.animationDuration,
        			easing: nSettings.animationEasing,
				}
			}

			_this.chartObj = new google.visualization.LineChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by donut chart
	AysChartBuilder.prototype.donutChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.chartConvertData( getChartSource );

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				fontSize: nSettings.chartFontSize,
				chartArea: {
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				enableInteractivity: nSettings.enableInteractivity,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					text: nSettings.tooltipText,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				pieStartAngle: nSettings.rotationDegree,
				pieSliceBorderColor: nSettings.sliceBorderColor,
				reverseCategories: nSettings.reverseCategories,
				pieSliceText: nSettings.sliceText,
				sliceVisibilityThreshold: nSettings.dataGroupingLimit,
				pieResidueSliceLabel: nSettings.dataGroupingLabel,
				pieResidueSliceColor: nSettings.dataGroupingColor,
				pieHole: nSettings.holeSize,
				slices: {}
			};

			for (var i = 0; i < dataTypes.length - 1; i++) {
				_this.chartOptions.slices[i] = {
					color: nSettings.sliceColor[i],
					offset: typeof nSettings.sliceOffset[i] !== 'undefined' ? nSettings.sliceOffset[i] : 0,
					textStyle: {
						color: nSettings.sliceTextColor[i],
					},
				}
			}

			_this.chartObj = new google.visualization.PieChart( document.getElementById(_this.htmlClassPrefix + _this.chartType) );

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by histogram
	AysChartBuilder.prototype.histogramView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.chartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.chartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				enableInteractivity: nSettings.enableInteractivity,
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic :nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
				},
				dataOpacity: nSettings.opacity,
				bar: {
					groupWidth: nSettings.groupWidth
				},
			};

			_this.chartObj = new google.visualization.Histogram(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by geo chart
	AysChartBuilder.prototype.geoChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.chartConvertData( getChartSource );

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		_this.enableGeoUrl = (settings['enable_url'] == 'checked') ? true : false;

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			var view = new google.visualization.DataView(_this.chartData);
    		view.setColumns([0, 1]);

			_this.chartOptions = {
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				fontSize: nSettings.chartFontSize,
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				enableRegionInteractivity: nSettings.enableInteractivity,
				keepAspectRatio: nSettings.keepAspectRatio,
			};

			_this.chartObj = new google.visualization.GeoChart( document.getElementById(_this.htmlClassPrefix + _this.chartType) );

			google.visualization.events.addListener(_this.chartObj, 'select', function () {
				if (_this.enableGeoUrl) {
					var selection = _this.chartObj.getSelection();
					if (selection.length > 0) {
						if (_this.chartData.getValue(selection[0].row, 2) != '') {
							window.open(_this.chartData.getValue(selection[0].row, 2), '_blank');
						}
					}
				}
			});

			_this.chartObj.draw( view, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by org chart
	AysChartBuilder.prototype.orgChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.orgChartConvertData(getChartSource);
		var treeData = _this.orgChartConvertDataForTreeManual(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['orgchart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			var view = new google.visualization.DataView(_this.chartData);
    		view.setColumns([0, 1, 2]);

			_this.chartOptions = {
				allowHtml: true,
				size: nSettings.orgChartFontSize,
				allowCollapse: nSettings.allowCollapse,
				nodeClass: nSettings.orgClassname,
			};

			_this.chartObj = new google.visualization.OrgChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			google.visualization.events.addListener(_this.chartObj, 'select', function () {
				var selection = _this.chartObj.getSelection();
				if (selection.length > 0) {
					if (_this.chartData.getValue(selection[0].row, 3) != '') {
						window.open(_this.chartData.getValue(selection[0].row, 3), '_blank');
					}
				}
			});
			
			google.visualization.events.addListener(_this.chartObj, 'collapse', function () {
				_this.setOrgChartCustomStyles();
			});

			_this.chartObj.draw( view, _this.chartOptions );
			_this.resizeChart();
			_this.setOrgChartCustomStyles();
		}

		var treeManualId = '#ays-chart-chart-source-data-edit-tree-content';
		var sortable = new TreeSortable({
			treeSelector: treeManualId,
		});
		var $treeManual = $(treeManualId);
		var $content = treeData.map(sortable.createBranch);
		$treeManual.html($content);
		sortable.run();

		sortable.addListener('click', '.add-child', function (event, instance) {
			instance.addChildBranch($(event.target), treeData);
		});
		sortable.addListener('click', '.add-sibling', function (event, instance) {
			instance.addSiblingBranch($(event.target), treeData);
		});

		sortable.addListener('click', '.remove-branch', function (event, instance) {
			event.preventDefault();
			var confirm = window.confirm('Are you sure you want to delete this branch?');
			if (!confirm) {
				return;
			}
			instance.removeBranch($(event.target));
		});

		sortable.addListener('click', '.open-branch-options', function (event, instance) {
			instance.openBranchOptions($(event.target));
		})

		sortable.addListener('click', '.close-branch-options', function (event, instance) {
			instance.closeBranchOptions($(event.target));
		})

		sortable.addListener('click', '.change-branch-options', function (event, instance) {
			instance.changeBranchOptions($(event.target));
		})
		
		tippy('[data-tippy-content]');
	}

	// Load chart by area chart
	AysChartBuilder.prototype.areaChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.multiColumnChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.removeRowOptions(_this.chartDataArray));

			_this.chartOptions = {
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.chartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				enableInteractivity: nSettings.enableInteractivity,
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					direction: nSettings.hAxisDirection,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic: nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					direction: nSettings.vAxisDirection,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
				},
				crosshair: {
					opacity: nSettings.crosshairOpacity,
					orientation: nSettings.crosshairOrientation,
					trigger: nSettings.crosshairTrigger,
				},
				focusTarget: nSettings.focusTarget,
				dataOpacity: nSettings.opacity,
				lineWidth: nSettings.lineWidth,
				selectionMode: nSettings.multipleSelection,
				aggregationTarget: nSettings.multipleDataFormat,
				pointShape: nSettings.pointShape,
				pointSize: nSettings.pointSize,
				curveType: nSettings.curveType,
				orientation: nSettings.orientation,
				interpolateNulls: nSettings.fillNulls,
				series: {},
			};

			for (var i = 0; i < dataTypes[0].length; i++) {
				_this.chartOptions.series[i] = {
					color: nSettings.seriesColor[i],
					visibleInLegend: nSettings.seriesVisibleInLegend[i] == 'on' ? true : (typeof nSettings.seriesColor[i] !== 'undefined' ? false : true),
				}
			}

			if (nSettings.enableAnimation) {
				_this.chartOptions.animation = {
					startup: nSettings.animationStartup,
					duration: nSettings.animationDuration,
        			easing: nSettings.animationEasing,
				}
			}

			_this.chartObj = new google.visualization.AreaChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by gauge chart
	AysChartBuilder.prototype.gaugeChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.chartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['gauge']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				minorTicks: nSettings.minorTicks,
			};

			_this.chartObj = new google.visualization.Gauge(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by combo chart
	AysChartBuilder.prototype.comboChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.multiColumnChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = nSettings.enableRowSettings ? _this.setRowOptions(dataTypes, nSettings, true) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				type: 'line',
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.chartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				enableInteractivity: nSettings.enableInteractivity,
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					direction: nSettings.hAxisDirection,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic: nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					direction: nSettings.vAxisDirection,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
				},
				crosshair: {
					opacity: nSettings.crosshairOpacity,
					orientation: nSettings.crosshairOrientation,
					trigger: nSettings.crosshairTrigger,
				},
				focusTarget: nSettings.focusTarget,
				dataOpacity: nSettings.opacity,
				lineWidth: nSettings.lineWidth,
				selectionMode: nSettings.multipleSelection,
				aggregationTarget: nSettings.multipleDataFormat,
				pointShape: nSettings.pointShape,
				pointSize: nSettings.pointSize,
				curveType: nSettings.curveType,
				series: {},
			};

			for (var i = 0; i < dataTypes[0].length; i++) {
				_this.chartOptions.series[i] = {
					color: nSettings.seriesColor[i],
					visibleInLegend: nSettings.seriesVisibleInLegend[i] == 'on' ? true : (typeof nSettings.seriesColor[i] !== 'undefined' ? false : true),
					type: typeof nSettings.comboType[i] !== 'undefined' ? nSettings.comboType[i] : 'line',
				}
			}

			if (nSettings.enableAnimation) {
				_this.chartOptions.animation = {
					startup: nSettings.animationStartup,
					duration: nSettings.animationDuration,
        			easing: nSettings.animationEasing,
				}
			}

			_this.chartObj = new google.visualization.ComboChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by stepped area chart
	AysChartBuilder.prototype.steppedAreaChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.multiColumnChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.removeRowOptions(_this.chartDataArray));

			_this.chartOptions = {
				enableInteractivity: nSettings.enableInteractivity,
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.chartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					direction: nSettings.hAxisDirection,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic: nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					direction: nSettings.vAxisDirection,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
				},
				focusTarget: nSettings.focusTarget,
				lineWidth: nSettings.lineWidth,
				selectionMode: nSettings.multipleSelection,
				aggregationTarget: nSettings.multipleDataFormat,
				series: {},
			};

			for (var i = 0; i < dataTypes[0].length; i++) {
				_this.chartOptions.series[i] = {
					color: nSettings.seriesColor[i],
					visibleInLegend: nSettings.seriesVisibleInLegend[i] == 'on' ? true : (typeof nSettings.seriesColor[i] !== 'undefined' ? false : true),
				}
			}

			if (nSettings.enableAnimation) {
				_this.chartOptions.animation = {
					startup: nSettings.animationStartup,
					duration: nSettings.animationDuration,
        			easing: nSettings.animationEasing,
				}
			}

			_this.chartObj = new google.visualization.SteppedAreaChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}
	
	// Load chart by bubble chart
	AysChartBuilder.prototype.bubbleChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.chart_data_by_types[_this.chartType] != undefined ? _this.chartSourceData.chart_data_by_types[_this.chartType] : _this.chartSourceData.source;
		var dataTypes = _this.bubbleChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				enableInteractivity: nSettings.enableInteractivity,
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.hartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					direction: nSettings.hAxisDirection,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic: nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					direction: nSettings.vAxisDirection,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
				},
				bubble: {
					opacity: nSettings.opacity
				},
				selectionMode: nSettings.multipleSelection,
			};

			if (nSettings.enableAnimation) {
				_this.chartOptions.animation = {
					startup: nSettings.animationStartup,
					duration: nSettings.animationDuration,
        			easing: nSettings.animationEasing,
				}
			}

			_this.chartObj = new google.visualization.BubbleChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}
	
	// Load chart by scatter chart
	AysChartBuilder.prototype.scatterChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.chart_data_by_types[_this.chartType] != undefined ? _this.chartSourceData.chart_data_by_types[_this.chartType] : _this.chartSourceData.source;
		var dataTypes = _this.scatterChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);
		
		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				enableInteractivity: nSettings.enableInteractivity,
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke:nSettings. borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.chartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					direction: nSettings.hAxisDirection,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic: nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					direction: nSettings.vAxisDirection,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
				},
				crosshair: {
					opacity: nSettings.crosshairOpacity,
					orientation: nSettings.crosshairOrientation,
					trigger: nSettings.crosshairTrigger,
				},
				interpolateNulls: nSettings.fillNulls,
				dataOpacity: nSettings.opacity,
				selectionMode: nSettings.multipleSelection,
				pointShape: nSettings.pointShape,
				pointSize: nSettings.pointSize,
			};

			if (nSettings.enableAnimation) {
				_this.chartOptions.animation = {
					startup: nSettings.animationStartup,
					duration: nSettings.animationDuration,
        			easing: nSettings.animationEasing,
				}
			}

			_this.chartObj = new google.visualization.ScatterChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}
	
	// Load chart by table chart
	AysChartBuilder.prototype.tableChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.chart_data_by_types[_this.chartType] != undefined ? _this.chartSourceData.chart_data_by_types[_this.chartType] : _this.chartSourceData.source;
		var dataTypes = _this.tableChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);
		
		/* == Google part == */
		google.charts.load('current', {'packages':['table']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				showRowNumber: nSettings.showRowNumber,
				sortColumn: nSettings.sortColumnIndex,
			};

			_this.chartObj = new google.visualization.Table(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}
	
	// Load chart by timeline chart
	AysChartBuilder.prototype.timelineChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.chart_data_by_types[_this.chartType] != undefined ? _this.chartSourceData.chart_data_by_types[_this.chartType] : _this.chartSourceData.source;
		var dataTypes = _this.timelineChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['timeline']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				enableInteractivity: nSettings.enableInteractivity,
				timeline: {
					showRowLabels: nSettings.showRowLabels,
					singleColor: nSettings.singleColor,
				},
			};

			_this.chartObj = new google.visualization.Timeline(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by candlestick chart
	AysChartBuilder.prototype.candlestickChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.chart_data_by_types[_this.chartType] != undefined ? _this.chartSourceData.chart_data_by_types[_this.chartType] : _this.chartSourceData.source;
		var dataTypes = _this.candlestickChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray, true);

			_this.chartOptions = {
				enableInteractivity: nSettings.enableInteractivity,
				fontSize: nSettings.chartFontSize,
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				chartArea: {
					backgroundColor: {
						fill: nSettings.chartBackgroundColor,
						stroke: nSettings.chartBorderColor,
						strokeWidth: nSettings.chartBorderWidth
					},
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				theme: nSettings.maximizedView,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				hAxis: {
					title: nSettings.hAxisTitle,
					textPosition: nSettings.hAxisTextPosition,
					direction: nSettings.hAxisDirection,
					textStyle: {
						color: nSettings.hAxisTextColor,
						fontSize: nSettings.hAxisTextFontSize,
						italic: nSettings.hAxisItalicText,
						bold: nSettings.hAxisBoldText,
					},
					slantedText: nSettings.hAxisSlantedText,
					slantedTextAngle: nSettings.hAxisSlantedTextAngle,
					format: nSettings.hAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.hAxisLabelFontSize,
						color: nSettings.hAxisLabelColor,
						italic: nSettings.hAxisItalicTitle,
						bold: nSettings.hAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.hAxisMinValue,
						max: nSettings.hAxisMaxValue,
					},
					gridlines: {
						count: nSettings.hAxisGridlinesCount,
						color: nSettings.hAxisGridlinesColor,
					},
				},
				vAxis: {
					title: nSettings.vAxisTitle,
					textPosition: nSettings.vAxisTextPosition,
					direction: nSettings.vAxisDirection,
					textStyle: {
						color: nSettings.vAxisTextColor,
						fontSize: nSettings.vAxisTextFontSize,
						italic: nSettings.vAxisItalicText,
						bold: nSettings.vAxisBoldText,
					},
					format: nSettings.vAxisFormat,
					titleTextStyle: {
						fontSize: nSettings.vAxisLabelFontSize,
						color: nSettings.vAxisLabelColor,
						italic: nSettings.vAxisItalicTitle,
						bold: nSettings.vAxisBoldTitle,
					},
					viewWindow: {
						min: nSettings.vAxisMinValue,
						max: nSettings.vAxisMaxValue,
					},
					gridlines: {
						count: nSettings.vAxisGridlinesCount,
						color: nSettings.vAxisGridlinesColor,
					},
				},
				bar: {
					groupWidth: nSettings.groupWidth
				},
				focusTarget: nSettings.focusTarget,
				selectionMode: nSettings.multipleSelection,
			};

			if (nSettings.enableAnimation) {
				_this.chartOptions.animation = {
					startup: nSettings.animationStartup,
					duration: nSettings.animationDuration,
        			easing: nSettings.animationEasing,
				}
			}

			_this.chartObj = new google.visualization.CandlestickChart(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by sankey diagram
	AysChartBuilder.prototype.sankeyDiagramView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.chart_data_by_types[_this.chartType] != undefined ? _this.chartSourceData.chart_data_by_types[_this.chartType] : _this.chartSourceData.source;
		var dataTypes = _this.sankeyDiagramConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['sankey']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				sankey: {
					link: {
						color: {
							fill: nSettings.linkColor,
							stroke: nSettings.linkBorderColor,
							strokeWidth: nSettings.linkBorderWidth,
						},
					},	
				},
			};

			_this.chartObj = new google.visualization.Sankey(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}
	
	// Load chart by treemap chart
	AysChartBuilder.prototype.treemapView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.chart_data_by_types[_this.chartType] != undefined ? _this.chartSourceData.chart_data_by_types[_this.chartType] : _this.chartSourceData.source;
		var dataTypes = _this.treemapConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['treemap']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				showScale: nSettings.showScale,
				minColor: nSettings.minColor,
				maxColor: nSettings.maxColor,
			};

			_this.chartObj = new google.visualization.TreeMap(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by gantt chart
	AysChartBuilder.prototype.ganttChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.chart_data_by_types[_this.chartType] != undefined ? _this.chartSourceData.chart_data_by_types[_this.chartType] : _this.chartSourceData.source;
		var dataTypes = _this.ganttChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['gantt']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				gantt: {
					percentEnabled: nSettings.percentEnabled
				},
			};

			_this.chartObj = new google.visualization.Gantt(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}
	
	// Load chart by word tree chart
	AysChartBuilder.prototype.wordTreeChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.chart_data_by_types[_this.chartType] != undefined ? _this.chartSourceData.chart_data_by_types[_this.chartType] : _this.chartSourceData.source;
		var dataTypes = _this.wordTreeChartConvertData(getChartSource);

		var treeFormat = (dataTypes[0].length == 1) ? 'implicit' : 'explicit';

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['wordtree']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				wordtree: {
					format: treeFormat,
				},
				maxFontSize: nSettings.maxFontSize,
			};

			_this.chartObj = new google.visualization.WordTree(document.getElementById(_this.htmlClassPrefix + _this.chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.$el.find("#" + _this.htmlClassPrefix + _this.chartType + " svg g rect:last-child").eq(0).hide();
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by 3d pie chart
	AysChartBuilder.prototype.pie3DChartView = function(isChangedType){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;

		var dataTypes = _this.chartConvertData( getChartSource );

		var settings = _this.chartSourceData.settings;
		var nSettings =  _this.configOptionsForCharts(settings);

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartDataArray = isChangedType ? _this.removeRowOptions(_this.chartDataArray) : dataTypes;
			_this.chartData = google.visualization.arrayToDataTable(_this.chartDataArray);

			_this.chartOptions = {
				is3D: true,
				fontSize: nSettings.chartFontSize,
				chartArea: {
					left: nSettings.chartLeftMargin,
					right: nSettings.chartRightMargin,
					top: nSettings.chartTopMargin,
					bottom: nSettings.chartBottomMargin,
				},
				backgroundColor: {
					fill: nSettings.backgroundColor,
					strokeWidth: nSettings.borderWidth,
					stroke: nSettings.borderColor
				},
				enableInteractivity: nSettings.enableInteractivity,
				legend: {
					position: nSettings.legendPosition,
					alignment: nSettings.legendAlignment,
					textStyle: {
						color: nSettings.legendColor,
						fontSize: nSettings.legendFontSize,
						italic: nSettings.legendItalicText,
						bold: nSettings.legendBoldText,
					}
				},
				tooltip: { 
					trigger: nSettings.tooltipTrigger,
					showColorCode: nSettings.showColorCode,
					text: nSettings.tooltipText,
					textStyle: {
						color: nSettings.tooltipTextColor,
						fontSize: nSettings.tooltipFontSize,
						italic: nSettings.tooltipItalicText,
						bold: nSettings.tooltipBoldText,
					}
				},
				pieStartAngle: nSettings.rotationDegree,
				pieSliceBorderColor: nSettings.sliceBorderColor,
				reverseCategories: nSettings.reverseCategories,
				pieSliceText: nSettings.sliceText,
				sliceVisibilityThreshold: nSettings.dataGroupingLimit,
				pieResidueSliceLabel: nSettings.dataGroupingLabel,
				pieResidueSliceColor: nSettings.dataGroupingColor,
				slices: {}
			};

			for (var i = 0; i < dataTypes.length - 1; i++) {
				_this.chartOptions.slices[i] = {
					color: nSettings.sliceColor[i],
					offset: typeof nSettings.sliceOffset[i] !== 'undefined' ? nSettings.sliceOffset[i] : 0,
					textStyle: {
						color: nSettings.sliceTextColor[i],
					},
				}
			}

			_this.chartObj = new google.visualization.PieChart( document.getElementById(_this.htmlClassPrefix + _this.chartType) );

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	/* 
	  Configure all settings for all chart types
	  Getting settings for each chart type in respective function 
	*/
	AysChartBuilder.prototype.configOptionsForCharts = function (settings) {
		var newSettings = {};

		newSettings.chartFontSize = settings['font_size'];
		newSettings.backgroundColor = settings['transparent_background'] && settings['transparent_background'] === 'checked' ? 'transparent' : settings['background_color'];
		newSettings.borderWidth = settings['border_width'];
		newSettings.borderColor = settings['border_color'];
		newSettings.tooltipTrigger = settings['tooltip_trigger'];
		newSettings.tooltipText = settings['tooltip_text'];
		newSettings.showColorCode = (settings['show_color_code'] == 'checked') ? true : false;
		newSettings.tooltipItalicText = (settings['tooltip_italic'] == 'checked') ? true : false;
		newSettings.tooltipBoldText = settings['tooltip_bold'];
		newSettings.legendItalicText = (settings['legend_italic'] == 'checked') ? true : false;
		newSettings.legendBoldText = (settings['legend_bold'] == 'checked') ? true : false;
		newSettings.tooltipTextColor = settings['tooltip_text_color'];
		newSettings.tooltipFontSize = settings['tooltip_font_size'];
		newSettings.legendPosition = settings['legend_position'];
		newSettings.legendAlignment = settings['legend_alignment'];
		newSettings.legendFontSize = settings['legend_font_size'];
		newSettings.rotationDegree = settings['rotation_degree'];
		newSettings.sliceBorderColor = settings['slice_border_color'];
		newSettings.reverseCategories = (settings['reverse_categories'] == 'checked') ? true : false;
		newSettings.sliceText = settings['slice_text'];
		newSettings.legendColor = settings['legend_color'];
		newSettings.dataGroupingLimit = settings['data_grouping_limit']/100;
		newSettings.dataGroupingLabel = settings['data_grouping_label'];
		newSettings.dataGroupingColor = settings['data_grouping_color'];
		newSettings.sliceColor = settings['slice_color'];
		newSettings.sliceOffset = settings['slice_offset'];
		newSettings.sliceTextColor = settings['slice_text_color'];
		newSettings.chartBackgroundColor = settings['transparent_background'] && settings['transparent_background'] === 'checked' ? 'transparent' : settings['chart_background_color'];
		newSettings.chartBorderWidth = settings['chart_border_width'];
		newSettings.chartBorderColor = settings['chart_border_color'];
		newSettings.chartLeftMargin = settings['chart_left_margin_for_js'];
		newSettings.chartRightMargin = settings['chart_right_margin_for_js'];
		newSettings.chartTopMargin = settings['chart_top_margin_for_js'];
		newSettings.chartBottomMargin = settings['chart_bottom_margin_for_js'];
		newSettings.isStacked = (settings['is_stacked'] == 'checked') ? true : false;
		newSettings.focusTarget = settings['focus_target'];
		newSettings.groupWidthFormat = settings['group_width_format'] == '%' ? '%' : '';
		newSettings.groupWidth = settings['group_width'] + newSettings.groupWidthFormat;
		newSettings.hAxisTitle = settings['haxis_title'];
		newSettings.vAxisTitle = settings['vaxis_title'];
		newSettings.hAxisLabelFontSize = settings['haxis_label_font_size'];
		newSettings.vAxisLabelFontSize = settings['vaxis_label_font_size'];
		newSettings.hAxisLabelColor = settings['haxis_label_color'];
		newSettings.vAxisLabelColor = settings['vaxis_label_color'];
		newSettings.hAxisTextPosition = settings['haxis_text_position'];
		newSettings.vAxisTextPosition = settings['vaxis_text_position'];
		newSettings.vAxisDirection = (settings['vaxis_direction'] == 'checked') ? -1 : 1;
		newSettings.hAxisDirection = (settings['haxis_direction'] == 'checked') ? -1 : 1;
		newSettings.hAxisTextColor = settings['haxis_text_color'];
		newSettings.vAxisTextColor = settings['vaxis_text_color'];
		newSettings.hAxisBaselineColor = settings['haxis_baseline_color'];
		newSettings.vAxisBaselineColor = settings['vaxis_baseline_color'];
		newSettings.hAxisTextFontSize = settings['haxis_text_font_size'];
		newSettings.vAxisTextFontSize = settings['vaxis_text_font_size'];
		newSettings.hAxisSlantedText = settings['haxis_slanted'];
		newSettings.hAxisSlantedTextAngle = settings['haxis_slanted_text_angle'];
		newSettings.hAxisShowTextEvery = settings['haxis_show_text_every'];
		newSettings.vAxisFormat = settings['vaxis_format'];
		newSettings.hAxisFormat = settings['haxis_format'];
		newSettings.hAxisMinValue = settings['haxis_min_value'];
		newSettings.hAxisMaxValue = settings['haxis_max_value'];
		newSettings.vAxisMinValue = settings['vaxis_min_value'];
		newSettings.vAxisMaxValue = settings['vaxis_max_value'];
		newSettings.hAxisGridlinesCount = settings['haxis_gridlines_count'];
		newSettings.hAxisGridlinesColor = settings['haxis_gridlines_color'];
		newSettings.hAxisMinorGridlinesColor = settings['haxis_minor_gridlines_color'];
		newSettings.vAxisGridlinesCount = settings['vaxis_gridlines_count'];
		newSettings.vAxisGridlinesColor = settings['vaxis_gridlines_color'];
		newSettings.vAxisMinorGridlinesColor = settings['vaxis_minor_gridlines_color'];
		newSettings.hAxisItalicText = (settings['haxis_italic'] == 'checked') ? true : false;
		newSettings.hAxisBoldText = (settings['haxis_bold'] == 'checked') ? true : false;
		newSettings.vAxisItalicText = (settings['vaxis_italic'] == 'checked') ? true : false;
		newSettings.vAxisBoldText = (settings['vaxis_bold'] == 'checked') ? true : false;
		newSettings.hAxisItalicTitle = (settings['haxis_title_italic'] == 'checked') ? true : false;
		newSettings.hAxisBoldTitle = (settings['haxis_title_bold'] == 'checked') ? true : false;
		newSettings.vAxisItalicTitle = (settings['vaxis_title_italic'] == 'checked') ? true : false;
		newSettings.vAxisBoldTitle = (settings['vaxis_title_bold'] == 'checked') ? true : false;
		newSettings.opacity = settings['opacity'];
		newSettings.enableInteractivity = (settings['enable_interactivity'] == 'checked') ? true : false;
		newSettings.maximizedView = (settings['maximized_view'] == 'checked') ? 'maximized' : null;
		newSettings.enableAnimation = (settings['enable_animation'] == 'checked') ? true : false;
		newSettings.animationDuration = settings['animation_duration'];
		newSettings.animationStartup = (settings['animation_startup'] == 'checked') ? true : false;
		newSettings.animationEasing = settings['animation_easing'];
		newSettings.seriesColor = settings['series_color'];
		newSettings.seriesVisibleInLegend = settings['series_visible_in_legend'];
		newSettings.enableRowSettings = (settings['enable_row_settings'] == 'checked') ? true : false;
		newSettings.rowsColor = settings['rows_color'];
		newSettings.rowsOpacity = settings['rows_opacity'];
		newSettings.multipleSelection = (settings['multiple_selection'] == 'checked') ? 'multiple' : 'single';
		newSettings.multipleDataFormat = settings['multiple_data_format'];
		newSettings.pointShape = settings['point_shape'];
		newSettings.pointSize = settings['point_size'];
		newSettings.lineWidth = settings['line_width'];
		newSettings.crosshairTrigger = settings['crosshair_trigger'];
		newSettings.crosshairOrientation = settings['crosshair_orientation'];
		newSettings.crosshairOpacity = settings['crosshair_opacity'];
		newSettings.orientation = (settings['orientation'] == 'checked') ? 'vertical' : 'horizontal';
		newSettings.curveType = settings['line_curve_type'];
		newSettings.fillNulls = (settings['fill_nulls'] == 'checked') ? true : false;
		newSettings.holeSize = settings['donut_hole_size'];
		newSettings.keepAspectRatio = (settings['keep_aspect_ratio'] == 'checked') ? true : false;
		newSettings.orgChartFontSize = settings['org_chart_font_size'];
		newSettings.allowCollapse = (settings['allow_collapse'] == 'checked') ? true : false;
		newSettings.orgClassname = settings['org_classname'];
		newSettings.minorTicks = settings['minor_ticks'];
		newSettings.comboType = settings['combo_type'];
		newSettings.showRowNumber = (settings['show_row_number'] == 'checked') ? true : false;
		newSettings.sortColumnIndex = +settings['sort_column_index'];
		newSettings.showRowLabels = (settings['show_row_labels'] == 'checked') ? true : false;
		newSettings.singleColor = (settings['timeline_single_color'] == 'checked') ? settings['timeline_color'] : null;
		newSettings.linkColor = settings['sankey_link_color'];
		newSettings.linkBorderColor = settings['sankey_border_color'];
		newSettings.linkBorderWidth = settings['sankey_border_width'];
		newSettings.showScale = (settings['show_scale'] == 'checked') ? true : false;
		newSettings.minColor = settings['min_color'];
		newSettings.maxColor = settings['max_color'];
		newSettings.percentEnabled = (settings['percent_enabled'] == 'checked') ? true : false;
		newSettings.maxFontSize = settings['max_font_size'];

		return newSettings;
	}

	AysChartBuilder.prototype.setRowOptions = function (data, options, isJS = true) {
		var _this = this;
		var rowTypes = ['bar_chart', 'line_chart', 'column_chart', 'combo_chart'];

		if (rowTypes.includes(_this.chartType) && data && data.length > 0) {
			if (data[0] && data[0].length == 2) {
				data[0].push({ role: 'style' });
				for (var i = 1; i < data.length; i++) {
					var opts = [];

					var color = isJS ? options.rowsColor[i - 1] : options.rows_color[i - 1];
					opts.push(color ? 'color:'+color : '');

					if (_this.chartType === 'bar_chart' || _this.chartType === 'line_chart' || _this.chartType === 'column_chart') {
						var opacity = isJS ? options.rowsOpacity[i - 1] : options.rows_opacity[i - 1];
						opts.push(opacity ? 'opacity:'+opacity : '');
					}

					data[i].push(opts.join(';'));
				}
			}
		}

		return data;
	}
	
	AysChartBuilder.prototype.removeRowOptions = function (data) {
		var _this = this;

		if (data && data.length > 0) {
			for (var i = 0; i < data.length; i++) {
				var row = data[i];
				if (row.length === 3 && typeof row[2] === 'object' && row[2].role === 'style') {
					data.forEach(function(item) {
						item.splice(2, 1);
					});
					break;
				}
			}
		}

		return data;
	}

	// Detect window resize moment to draw charts responsively 
	AysChartBuilder.prototype.resizeChart = function(){
		var _this = this;

		//create trigger to resizeEnd event     
		$(window).resize(function() {
			if(this.resizeTO) clearTimeout(this.resizeTO);
			this.resizeTO = setTimeout(function() {
				$(this).trigger('resizeEnd');
			}, 100);
		});
	
		//redraw graph when window resize is completed 
		$(window).on('resizeEnd', function() {
			_this.drawChartFunction( _this.chartData, _this.chartOptions );
		});
		
	}

	AysChartBuilder.prototype.setOrgChartCustomStyles = function () {
		var _this = this;
		var settings = _this.chartSourceData.settings;

		var orgClassname = _this.chartSourceData.settings.org_classname;
		var bgColor = _this.chartSourceData.settings.org_node_background_color;
		var padding = _this.chartSourceData.settings.org_node_padding;
		var borderRadius = _this.chartSourceData.settings.org_node_border_radius;
		var borderWidth = _this.chartSourceData.settings.org_node_border_width;
		var borderColor = _this.chartSourceData.settings.org_node_border_color;
		var textColor = _this.chartSourceData.settings.org_node_text_color;
		var textSize = _this.chartSourceData.settings.org_node_text_font_size;
		var descriptionColor = _this.chartSourceData.settings.org_node_description_font_color;
		var descriptionSize = _this.chartSourceData.settings.org_node_description_font_size;
		
		if (orgClassname != '') {
			var node = _this.$el.find('.' + orgClassname);
			node.css({
				'background-color' : bgColor,
				'padding' : padding + 'px',
				'border-radius' : borderRadius + 'px',
				'color' : textColor,
				'font-size' : textSize + 'px',
				'border' : 'none',
				'outline' : borderWidth + 'px solid ' + borderColor,
			});
		}

		var description = _this.$el.find('.' + _this.htmlClassPrefix + 'org-chart-tree-description');
		description.css({
			'color' : descriptionColor,
			'font-size' : descriptionSize + 'px',
		});
		
		var image = _this.$el.find('.' + _this.htmlClassPrefix + 'org-chart-tree-image');
	}

	// Converting chart data for one column chart
	AysChartBuilder.prototype.chartConvertData = function( data ){
		var _this = this;
		var dataTypes = [];

		if (data[0] == undefined) {
			var titles = ['Title0', 'Title1'];
			if (_this.chartType == 'geo_chart') {
				titles.push('Url');
			}
			data[0] = titles;
		}

		// Collect data in new array for chart rendering
		for ( var key in data ) {
			if ( data.hasOwnProperty( key ) ) {
				if (key == 0) {
					if (data[key][0] != '' && data[key][1] != '') {
						if (data[0][2] != undefined) {
							dataTypes.push([
								_this.htmlDecode(data[key][0]), _this.htmlDecode(data[key][1]), data[key][2]
							]);
						} else {
							dataTypes.push([
								_this.htmlDecode(data[key][0]), _this.htmlDecode(data[key][1])
							]);
						}
					}
				} else {
					if (data[key][0] != '' && data[key][1] != '') {
						if (data[0][2] != undefined) {
							if (data[key][2] == undefined) {
								dataTypes.push([
									_this.htmlDecode(data[key][0]), +(data[key][1]), ''
								]);
							} else {
								dataTypes.push([
									_this.htmlDecode(data[key][0]), +(data[key][1]), data[key][2]
								]);
							}
						} else {
							dataTypes.push([
								_this.htmlDecode(data[key][0]), +(data[key][1])
							]);
						}
					}
				}
			}
		}

		return dataTypes;
	}

	// Converting chart data for multicolumn chart
	AysChartBuilder.prototype.multiColumnChartConvertData = function( data ){
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		if (data[0] == undefined) {
			var titles = [];
			for (var i = 0; i < data[1].length; i++) {
				titles.push("Title"+i);
			}
			data[0] = titles;
		}

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						if (data[key][index] != '') {
							titleRow.push(_this.htmlDecode(data[key][index]));
						}
					}
					dataTypes.push(titleRow);
				} else {
					for (var index in data[key]) {
						if  (index == 0) {
							if (data[key][index] != '') {
							   dataRow.push(_this.htmlDecode(data[key][index]));
							}
						} else {
							dataRow.push(+data[key][index]);
						}
 						}
					dataTypes.push(dataRow);
				}
			}
		}

		return dataTypes;
	}

	// Converting chart data for org chart type
	AysChartBuilder.prototype.orgChartConvertData = function( data ){
		var _this = this;
		var dataTypes = [['Name', 'Manager', 'Tooltip', 'Url']];
		// var name = "";
		// Collect data in new array for chart rendering
		for ( var key in data ) {
			if ( data.hasOwnProperty( key ) ) {
				if (key != 0) {
					var name = data[key][0];
					var description = data[key][1];
					var image = (data[key].length > 6) ? data[key][2] : '';
					var parent_name = (data[key].length > 6) ? data[key][3] : data[key][2];
					var tooltip = (data[key].length > 6) ? data[key][4] : data[key][3];
					var url = (data[key].length > 6) ? data[key][5] : '';
					
					if (description) {
						name += _this.orgChartFormatName(description);
					}
					if (image && image != '') {
						name = _this.orgChartFormatImage(image) + name;
					}
					name = {'v': data[key][0], 'f': name};
					dataTypes.push([
						name, parent_name, tooltip, url
					]);
				}
			}
		}

		return dataTypes;
	}

	AysChartBuilder.prototype.orgChartFormatName = function( description ){
		return `<div class="${this.htmlClassPrefix}org-chart-tree-description">${description}</div>`;
	}
	
	AysChartBuilder.prototype.orgChartFormatImage = function( image ){
		return `<div class="${this.htmlClassPrefix}org-chart-tree-image"><img width="128px" src="${image}"></div>`;
	}

	AysChartBuilder.prototype.orgChartConvertDataForTreeManual = function( source ){
		var _this = this;
		var treeDataArr = [];
		var ordering = _this.chartSourceData.source_ordering;
		source = Object.assign({}, source);
		if ( !$.isArray(source) ) {
			for (var index in ordering) {
				var key = (ordering[index]);

				var id = key;
				var title = source[key][0];
				var description = source[key][1];
				var image = (source[key].length > 6) ? source[key][2] : '';
				var parent_name = (source[key].length > 6) ? source[key][3] : source[key][2];
				var tooltip = (source[key].length > 6) ? source[key][4] : source[key][3];
				var url = (source[key].length > 6) ? source[key][5] : '';
				var parent_id = (source[key].length > 6) ? source[key][6].toString() : source[key][4].toString();
				var level = (source[key].length > 6) ? source[key][7].toString() : source[key][5].toString();

				// var ID = (source[0] == undefined) ? key : key + 1;
				treeDataArr[index] = {
					id: id,
					parent_id: parent_id,
					title: title,
					level: level,
					description: description,
					image: image,
					tooltip: tooltip,
					url: url,
					parent_name: parent_name
				}
			}
		}

		return treeDataArr;
	}

	// Converting chart data for bubble chart type
	AysChartBuilder.prototype.bubbleChartConvertData = function( data ) {
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						if (data[key][index] != '') {
							titleRow.push(_this.htmlDecode(data[key][index]));
						}
					}
					dataTypes.push(titleRow);
				} else {
					for (var index in data[key]) {
						if  (index == 0 || index == 3) {
							if (data[key][index] != '') {
							   dataRow.push(_this.htmlDecode(data[key][index]));
							}
						} else {
							dataRow.push(+data[key][index]);
						}
					}
					dataTypes.push(dataRow);
				}
			}
		}

		return dataTypes;
	}

	// Converting chart data for scatter chart type
	AysChartBuilder.prototype.scatterChartConvertData = function( data ) {
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						if (data[key][index] != '') {
							titleRow.push(_this.htmlDecode(data[key][index]));
						}
					}
					dataTypes.push(titleRow);
				} else {
					for (var index in data[key]) {
						if (data[key][index] != null) {
							dataRow.push(+data[key][index]);
						} else {
							dataRow.push(null);
						}
					}
					dataTypes.push(dataRow);
				}
			}
		}

		return dataTypes;
	}
	
	// Converting chart data for table chart type
	AysChartBuilder.prototype.tableChartConvertData = function( data ) {
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						if (data[key][index] != '') {
							titleRow.push(_this.htmlDecode(data[key][index]));
						}
					}
					dataTypes.push(titleRow);
				} else {
					for (var index in data[key]) {
						if (data[key][index].toString().toLowerCase() == 'true') {
							dataRow.push(true);
						} else if (data[key][index].toString().toLowerCase() == 'false') {
							dataRow.push(false);
						} else {
							dataRow.push(data[key][index]);
						}
					}
					dataTypes.push(dataRow);
				}
			}
		}
		
		return dataTypes;
	}

	// Converting chart data for timeline chart type
	AysChartBuilder.prototype.timelineChartConvertData = function( data ) {
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						titleRow.push(_this.htmlDecode(data[key][index]));
					}
					dataTypes.push(titleRow);
				} else {
					data[key].reverse();
					for (var index in data[key]) {
						if (index == 0 || index == 1) {
							dataRow.push(new Date(data[key][index]));
						} else {
							dataRow.push(_this.htmlDecode(data[key][index]));
						}
					}
					dataTypes.push(dataRow.reverse());
				}
			}
		}
		
		return dataTypes;
	}

	// Converting chart data for candlestick chart
	AysChartBuilder.prototype.candlestickChartConvertData = function( data ){
		var _this = this;
		var dataTypes = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				for (var index in data[key]) {
					if  (index == 0) {
						dataRow.push(_this.htmlDecode(data[key][index]));
					} else {
						dataRow.push(+data[key][index]);
					}
				}
				dataTypes.push(dataRow);
			}
		}

		return dataTypes;
	}

	// Converting chart data for sankey chart type
	AysChartBuilder.prototype.sankeyDiagramConvertData = function( data ) {
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						titleRow.push(_this.htmlDecode(data[key][index]));
					}
					dataTypes.push(titleRow);
				} else {
					for (var index in data[key]) {
						if (index == 2) {
							dataRow.push(+data[key][index]);
						} else {
							dataRow.push(_this.htmlDecode(data[key][index]));
						}
					}
					dataTypes.push(dataRow);
				}
			}
		}
		
		return dataTypes;
	}
	
	// Converting chart data for treemap chart type
	AysChartBuilder.prototype.treemapConvertData = function( data ) {
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						titleRow.push(_this.htmlDecode(data[key][index]));
					}
					dataTypes.push(titleRow);
				} else {
					for (var index in data[key]) {
						if (data[key][index] == null) {
							dataRow.push(null);
						} else {
							if (index == 0 || index == 1) {
								dataRow.push(_this.htmlDecode(data[key][index]));
							} else {
								dataRow.push(+data[key][index]);
							}
						}
					}
					dataTypes.push(dataRow);
				}
			}
		}
		
		return dataTypes;
	}
	
	// Converting chart data for gantt chart type
	AysChartBuilder.prototype.ganttChartConvertData = function( data ) {
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						if (index == 3 || index == 4) {
							titleRow.push({label: _this.htmlDecode(data[key][index]), type: 'date'});
						} else if (index == 5 || index == 6) {
							titleRow.push({label: _this.htmlDecode(data[key][index]), type: 'number'});
						} else {
							titleRow.push(_this.htmlDecode(data[key][index]));
						}
					}
					dataTypes.push(titleRow);
				} else {
					for (var index in data[key]) {
						if (data[key][index] == 'null' || data[key][index] == null) {
							dataRow.push(null);
						} else {
							if (index == 3 || index == 4) {
								dataRow.push(new Date(data[key][index]));
							} else if (index == 5) {
								dataRow.push(+data[key][index] * 24 * 60 * 60 * 1000);
							} else if (index == 6) {
								dataRow.push(+data[key][index]);
							} else {
								dataRow.push(_this.htmlDecode(data[key][index]));
							}
						}
					}
					dataTypes.push(dataRow);
				}
			}
		}
		
		return dataTypes;
	}

	// Converting chart data for word tree chart
	AysChartBuilder.prototype.wordTreeChartConvertData = function( data ){
		var _this = this;
		var dataTypes = [];

		if (data[0].length == 1) {
			for (var key in data) {
				var dataRow = [];
				if (data.hasOwnProperty(key)) {
					for (var index in data[key]) {
						dataRow.push(_this.htmlDecode(data[key][index]));
					}
				}
				dataTypes.push(dataRow);
			}
			if (_this.chartOptions) {
				_this.chartOptions.wordtree.format = 'implicit';
			}
		} else {
			for ( var key in data ) {
				if ( data.hasOwnProperty( key ) ) {
					if (key == 0) {
						dataTypes.push([
							{label: _this.htmlDecode(data[key][0]), type: 'number'}, _this.htmlDecode(data[key][1]), {label: _this.htmlDecode(data[key][2]), type: 'number'}, {label: _this.htmlDecode(data[key][3]), type: 'number'}, {label: _this.htmlDecode(data[key][4]), type: 'number'}
						]);
					} else {
						dataTypes.push([
							+data[key][0], _this.htmlDecode(data[key][1]), +data[key][2], +data[key][3], +data[key][4]
						]);
					}
				}
			}
			if (_this.chartOptions) {
				_this.chartOptions.wordtree.format = 'explicit';
			}
		}

		return dataTypes;
	}

	// Update chart data and display immediately
	AysChartBuilder.prototype.updateChartData =  function( newData ){
		var _this = this;
		_this.drawChartFunction( newData, _this.chartOptions );
	}

	AysChartBuilder.prototype.addChartDataRow = function (element){
        var _this = this;
        // var deleteImageUrl = ChartBuilderSourceData.removeManualDataRow;
        var content = '';

        var addedTermsandConds = this.$el.find("."+this.htmlClassPrefix+"chart-source-data-edit-block");
        var addedTermsandCondsId = this.$el.find("."+this.htmlClassPrefix+"chart-source-data-edit-block:last-child");
        var dataId = addedTermsandConds.length >= 1 ? addedTermsandCondsId.data("sourceId") + 1 : 1;
		var colCount = addedTermsandConds.first().children().length - 1;

		var className = 'chart-source-data-input-number';
		var inputType = 'number';
		var disabled = '';
		if (_this.chartType == 'geo_chart') {
			className = 'chart-source-data-input-url';
			inputType = 'text';
			
			var title = _this.$el.find('.ays-chart-url-box .ays-chart-chart-source-title-input');
			var inputs = _this.$el.find('.ays-chart-chart-source-data-input-url input[type="text"]');
			disabled = 'readonly';
			if (!(title.prop("readonly") && inputs.prop("readonly"))) {
				disabled = '';
			}
		}

        var termsCondsMessageAttrName = this.newTermsCondsMessageAttrName(  this.htmlNamePrefix + 'chart_source_data' ,  dataId );

		content += '<div class = "'+this.htmlClassPrefix+'chart-source-data-edit-block" data-source-id="' + dataId + '" >';
			content += '<div class="'+this.htmlClassPrefix+'chart-source-data-move-block '+this.htmlClassPrefix+'chart-source-data-move-row">';
				content += '<svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><path d="M278.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l9.4-9.4V224H109.3l9.4-9.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-9.4-9.4H224V402.7l-9.4-9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-9.4 9.4V288H402.7l-9.4 9.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4H288V109.3l9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64z" style="fill: #b8b8b8;"/></svg>';
			content += '</div>';
			content += '<div class="'+this.htmlClassPrefix+'icons-box '+this.htmlClassPrefix+'icons-remove-box">';
			content += '<svg class="'+this.htmlClassPrefix+'chart-source-data-remove-block '+this.htmlClassPrefix+'chart-source-data-remove-row" data-trigger="hover" data-bs-toggle="tooltip" title="Delete row" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M310.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L160 210.7 54.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L114.7 256 9.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 301.3 265.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L205.3 256 310.6 150.6z" style="fill: #b8b8b8;"/></svg>';
			content += '</div>';
			for (var i = 0; i < colCount; i++) {
				if (i == 0) {
					content += '<div class="'+this.htmlClassPrefix+'chart-source-data-input-box '+this.htmlClassPrefix+'chart-source-data-name-input-box" data-cell-id="'+i+'">';
						content += '<input type="text" class="ays-text-input form-control" name="' + termsCondsMessageAttrName + '">';
					content += '</div>';
				} else if (i == 2) {
					var stepAttr = inputType === 'number' ? 'step="any"' : '';
					content += '<div class="'+this.htmlClassPrefix+'chart-source-data-input-box ' + this.htmlClassPrefix + className + '">';
						content += '<input type="' + inputType + '" class="ays-text-input form-control" name="' + termsCondsMessageAttrName + '" ' + disabled + ' ' + stepAttr + '>';
					content += '</div>';
				} else {
					content += '<div class="'+this.htmlClassPrefix+'chart-source-data-input-box '+this.htmlClassPrefix+'chart-source-data-input-number" data-cell-id="'+i+'">';
						content += '<input type="number" class="ays-text-input form-control" name="' + termsCondsMessageAttrName + '" step="any">';
					content += '</div>';
				}
			}
		content += '</div>';

		this.$el.find('.'+this.htmlClassPrefix+'chart-source-data-content').append(content);
		$('[data-bs-toggle="tooltip"]').tooltip();
	}

	AysChartBuilder.prototype.addChartDataColumn = function (e){
		var _this = this;

		var rows = _this.$el.find("."+_this.htmlClassPrefix+"chart-source-data-content").children();
		var lastColId = +$(rows[0]).find('.'+_this.htmlClassPrefix+'chart-source-data-input-box:last-child').attr('data-cell-id');
		rows.each(function(key, row){
			var dataIDEach = row.getAttribute('data-source-id');
			var content = '';

			if (key === 0) {
				content += '<div class="'+_this.htmlClassPrefix+'chart-source-data-input-box ' +_this.htmlClassPrefix+'chart-source-title-box" data-cell-id="'+(lastColId+1)+'">';
					content += '<svg class="'+_this.htmlClassPrefix+'chart-source-data-remove-block '+_this.htmlClassPrefix+'chart-source-data-remove-col" data-trigger="hover" data-bs-toggle="tooltip" title="Delete column" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="10px">';
						content += '<path d="M310.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L160 210.7 54.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L114.7 256 9.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 301.3 265.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L205.3 256 310.6 150.6z" style="fill: #b8b8b8;"/>';
					content += '</svg>';

					content += '<div class="' + _this.htmlClassPrefix + 'chart-source-data-titles-box-item">';
						content += '<input type="text" class="ays-text-input form-control ' + _this.htmlClassPrefix+'chart-source-title-input" name="' + _this.newTermsCondsMessageAttrName(  _this.htmlNamePrefix + 'chart_source_data' ,  dataIDEach ) + '">';
						content += '<svg class="' + _this.htmlClassPrefix + 'chart-source-data-sort" data-sort-order="asc" xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512">';
							content += '<path d="M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zm0 429.3l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128c-12.5 12.5-32.8 12.5-45.3 0z" style="fill: #b8b8b8;"/>';
						content += '</svg>';
					content += '</div>'
				content += '</div>';
			} else {
				content += '<div class="'+_this.htmlClassPrefix+'chart-source-data-input-box ' +_this.htmlClassPrefix+'chart-source-data-input-number" data-cell-id="'+(lastColId+1)+'">';
					content += '<input type="number" class="ays-text-input form-control" name="' + _this.newTermsCondsMessageAttrName(  _this.htmlNamePrefix + 'chart_source_data' ,  dataIDEach ) + '" step="any">';
				content += '</div>';
			}

			$(row).append(content);
			$('[data-bs-toggle="tooltip"]').tooltip();
		});
	}

	AysChartBuilder.prototype.deleteChartDataRow = function (element){
		var _this = this;

		var rows = _this.$el.find("."+_this.htmlClassPrefix+"chart-source-data-content").children();
		if ((rows.length - 1) >= 2) {
			var confirm = window.confirm(aysChartBuilderAdmin.confirmRowDelete);
			if (confirm) {
				var thisMainParent = element.parent().parent();
				thisMainParent.remove();
			}
		} else {
			alert(aysChartBuilderAdmin.minRowNotice);
		}

		element.blur();
		element.tooltip('hide');
	}

	AysChartBuilder.prototype.deleteChartDataColumn = function (element){
		var _this = this;

		var rows = _this.$el.find("."+_this.htmlClassPrefix+"chart-source-data-content").children();
		if (rows.eq(1).children('.ays-chart-chart-source-data-input-number').length >= 2) {
			var confirm = window.confirm(aysChartBuilderAdmin.confirmColDelete);
			if (confirm) {
				var parent = element.parents('.ays-chart-chart-source-title-box');
				var index = _this.returnIndexOfEl(parent);
				rows.each(function(key, row){
					var dataRow = $(row).find('.ays-chart-chart-source-data-input-box:not("ays-chart-chart-source-data-name-input-box")');
					$(dataRow).each(function(ind, cell){
						if (ind == index) {
							$(cell).remove();
						}
					});
				});
			}
		} else {
			alert(aysChartBuilderAdmin.minColNotice);
		}

		element.blur();
		element.tooltip('hide');
	}
	
	AysChartBuilder.prototype.sortDataByColumn = function (el) {
		var _this = this;

		var sortingOrder = el.attr('data-sort-order');
		var colFirst = el.parents('.'+_this.htmlClassPrefix+'chart-source-data-input-box');
		var colIndex = colFirst.attr('data-cell-id');
		var colList = colFirst.parents('.'+_this.htmlClassPrefix+'chart-source-data-content').find('.'+_this.htmlClassPrefix+'chart-source-data-input-box[data-cell-id="'+colIndex+'"] input.ays-text-input');

		var sorted = {};
		colList.each(function(key, input){
			if (key !== 0) {
				var rowIndex = $(input).parents('.'+_this.htmlClassPrefix+'chart-source-data-edit-block').attr('data-source-id');
				sorted[rowIndex] = +input.value
			}
		});
		
		if (sortingOrder === 'asc') {
			sorted = _this.sortDataAsc(sorted);
			el.attr('data-sort-order', 'desc');
		} else if (sortingOrder === 'desc') {
			sorted = _this.sortDataDesc(sorted);
			el.attr('data-sort-order', 'asc');
		} else {
			sorted = _this.sortDataAsc(sorted);
			el.attr('data-sort-order', 'desc');
		}
		
		var container = _this.$el.find('.'+_this.htmlClassPrefix+'chart-source-data-content');
		var newContainer = [];
		sorted.forEach((index, newIndex) => {
			var row = container.find("."+_this.htmlClassPrefix+"chart-source-data-edit-block[data-source-id='"+index+"']");
			var inputs = row.find('input.ays-text-input');
			var inputName =  _this.newTermsCondsMessageAttrName(_this.htmlNamePrefix + 'chart_source_data', newIndex + 1);
			
			$(inputs).each(function (inputIndex, input) {
				input.setAttribute('name', inputName);
			});

			newContainer.push(row);
		});
		sorted.forEach((index, newIndex) => {
			var row = container.find("."+_this.htmlClassPrefix+"chart-source-data-edit-block[data-source-id='"+index+"']");
			newContainer.push(row);
		});
		
		container.innerHTML = '';
		newContainer.forEach(row => {
			container.append(row);
		});

		var rows = container.find("."+_this.htmlClassPrefix+"chart-source-data-edit-block");
		for (var i = 0; i < rows.length; i++) {
			$(rows[i]).attr('data-source-id', i);
		}
	}

	AysChartBuilder.prototype.sortDataAsc = function (data) {
		return Object.keys(data).sort(function (a, b) {return data[a] - data[b]});
	}

	AysChartBuilder.prototype.sortDataDesc = function (data) {
		return Object.keys(data).sort(function (a, b) {return data[b] - data[a]});
	}
	
	AysChartBuilder.prototype.returnIndexOfEl = function (element){
		var i = 0;
		var elements = element.parent().find('.ays-chart-chart-source-title-box');
		elements.each(function(key, cell){
			if ($(cell).is(element)) {
				i = key;
			}
		});
		return i;
	}

	AysChartBuilder.prototype.configureOptions = function() {
        var _this = this;

		var sourceAccordions = _this.$el.find('.ays-tab-content#tab1 .ays-accordions-container fieldset');
		if (_this.nonManualTypes.includes(_this.chartType)) {
			_this.openFirstTab(sourceAccordions);
		}

		var removeCols = _this.$el.find('.ays-chart-chart-source-title-box').find('.ays-chart-chart-source-data-remove-block');
		if (_this.chartType !== 'bar_chart' && _this.chartType !== 'column_chart' && _this.chartType !== 'line_chart' && _this.chartType !== 'area_chart' && _this.chartType !== 'combo_chart' && _this.chartType !== 'stepped_area_chart') {
			removeCols.css('visibility', 'hidden');
		}
		_this.$el.find('.ays-chart-chart-source-title-box').eq(0).find('.ays-chart-chart-source-data-remove-block').css('visibility', 'hidden');
		
		var options = _this.$el.find('.cb-changable-opt');
		var typeOptions = _this.$el.find('.cb-'+_this.chartType+'-opt');
		options.addClass('display_none');
		typeOptions.removeClass('display_none');
		
		var manualTabs = _this.$el.find('.cb-changable-manual:not(.cb-'+_this.chartType+'-manual)');
		var typeManualTab = _this.$el.find('.cb-'+_this.chartType+'-manual');
		manualTabs.remove();
		typeManualTab.removeClass('display_none');
		
		var tabs = _this.$el.find('.cb-changable-tab:not(.cb-'+_this.chartType+'-tab)').parents('fieldset.ays-accordion-options-container');
		var currentTabs = _this.$el.find('.cb-'+_this.chartType+'-tab').parents('fieldset.ays-accordion-options-container');
		tabs.addClass('display_none');
		currentTabs.removeClass('display_none');
	}

	AysChartBuilder.prototype.changeChartType = function () {
		var _this = this;

		_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-type').val(_this.chartType);
		_this.$el.find('.'+_this.htmlClassPrefix+'type-info-box-text-changeable').text(_this.chartSources[_this.chartType]);
		_this.$el.find('.'+_this.htmlClassPrefix+'nav-tab-chart.nav-tab[data-tab="tab4"]').text(_this.chartSourceData.chartTypesNames[_this.chartType]+" settings");
		_this.$el.find('.'+_this.htmlClassPrefix+'advanced-settings .ays-accordion-options-container:first-child legend.ays-accordion-options-header span').text(_this.chartSourceData.chartTypesNames[_this.chartType]+" settings");
		_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').attr('id' , _this.htmlClassPrefix+_this.chartType);

		_this.configureOptions();
		_this.loadChartBySource(true);
	}

	AysChartBuilder.prototype.openFirstTab = function (parent, contType = "") {
		var check = true;
		for (var i = 0; i < parent.length - 1; i++){
			if ($(parent[i]).attr('data-collapsed') == 'false') check = false;
		}
		if (check) {
			var container = parent.eq(0);
			setTimeout(() => {
				container.find('.ays' + contType + '-accordion-options-content').slideDown();
				container.attr('data-collapsed', 'false');
				container.find('.ays' + contType + '-accordion-options-header .ays' + contType + '-accordion-arrow').find('path').css('fill', '#008cff');
				container.find('.ays' + contType + '-accordion-options-header .ays' + contType + '-accordion-arrow').removeClass('ays' + contType + '-accordion-arrow-right').addClass('ays' + contType + '-accordion-arrow-down');
			}, 150);
		}
	}

	AysChartBuilder.prototype.newTermsCondsMessageAttrName = function (termCondName, termCondId){
		var _this = this;
		return termCondName + '['+ termCondId +'][]';	
	}
    
    AysChartBuilder.prototype.setAccordionEvents = function(e){
        var _this = this;

        _this.$el.on('click', '.ays-accordion-options-header', function(e){
			_this.openCloseAccordion(e, _this);
		});

		_this.$el.on('click', '.ays-slices-accordion-options-header', function(e){
			_this.openCloseAccordion(e, _this, '-slices');
		});
		
		_this.$el.on('click', '.ays-series-accordion-options-header', function(e){
			_this.openCloseAccordion(e, _this, '-series');
		});
		
		_this.$el.on('click', '.ays-rows-accordion-options-header', function(e){
			_this.openCloseAccordion(e, _this, '-rows');
		});
    }
	
	AysChartBuilder.prototype.openCloseAccordion = function(e, _this, contType = ""){
		var container = $(e.target).parents('.ays' + contType + '-accordion-options-container');
		var parent = (contType != "") ? container.parents('.ays-chart' + contType + '-settings') : _this.$el.find('#' + container.parents('.ays-tab-content').attr('id') + ' .ays-accordions-container').eq(0);
		var index = (contType != "") ? container.index() : -1;

        if( container.attr('data-collapsed') === 'true' ){
			_this.closeAllAccordions( parent, contType, index );
			setTimeout(() => {
				container.find('.ays' + contType + '-accordion-options-content').slideDown();
				container.attr('data-collapsed', 'false');
				container.find('.ays' + contType + '-accordion-options-header .ays' + contType + '-accordion-arrow').find('path').css('fill', '#008cff');
				container.find('.ays' + contType + '-accordion-options-header .ays' + contType + '-accordion-arrow').removeClass('ays' + contType + '-accordion-arrow-right').addClass('ays' + contType + '-accordion-arrow-down');
			}, 150);
        }else{
			setTimeout(() => {
				container.find('.ays' + contType + '-accordion-options-content').slideUp();
				container.attr('data-collapsed', 'true');
				container.find('.ays' + contType + '-accordion-options-header .ays' + contType + '-accordion-arrow').find('path').css('fill', '#c4c4c4');
				container.find('.ays' + contType + '-accordion-options-header .ays' + contType + '-accordion-arrow').removeClass('ays' + contType + '-accordion-arrow-down').addClass('ays' + contType + '-accordion-arrow-right');
			}, 150);
        }
    }
    
    AysChartBuilder.prototype.closeAllAccordions = function( container, contType, index ){
		var _this = this;

		container.find('.ays' + contType + '-accordion-options-container').each(function (i){
			var $this = $(this);
			if (i != index) {
				setTimeout(() => {
					$this.find('.ays' + contType + '-accordion-options-content').slideUp();
					$this.attr('data-collapsed', 'true');
					$this.find('.ays' + contType + '-accordion-options-header .ays' + contType + '-accordion-arrow').find('path').css('fill', '#c4c4c4');
					$this.find('.ays' + contType + '-accordion-options-header .ays' + contType + '-accordion-arrow').removeClass('ays' + contType + '-accordion-arrow-down').addClass('ays' + contType + '-accordion-arrow-right');
				}, 150);
			}
		});
    }

	AysChartBuilder.prototype.initDbImportComponent = function(){
		var _this = this;
		var table_columns = window.aysChartBuilderChartSettings.db_query.tables;
		var code_mirror = wp.CodeMirror || CodeMirror;
		var cm = code_mirror.fromTextArea(_this.$el.find('.ays-chart-db-query').get(0), {
			value: _this.$el.find('.ays-chart-db-query').val(),
			autofocus: false,
			mode: 'text/x-mysql',
			lineWrapping: true,
			dragDrop: false,
			matchBrackets: true,
			autoCloseBrackets: true,
			extraKeys: {"Ctrl-Space": "autocomplete"},
			hintOptions: { tables: table_columns }
		});

		// force refresh so that the query shows on first time load. Otherwise you have to click on the editor for it to show.
		_this.$el.on('ays-chart:db:query:focus', function(event, data){
			cm.refresh();
		});

		// cm.focus();

		// update text area.
		cm.on('inputRead', function(x, y){
			cm.save();
		});

		// backspace and delete do not register so the text box does not get empty if the entire query is deleted
		// from the editor. Let's force this.
		_this.$el.on('ays-chart:db:query:update', function(event, data){
			cm.save();
		});

		// clear the editor.
		_this.$el.on('ays-chart:db:query:setvalue', function(event, data){
			cm.setValue(data.value);
			cm.clearHistory();
			cm.refresh();
		});

		// set an option at runtime?
		_this.$el.on('ays-chart:db:query:changeoption', function(event, data){
			cm.setOption(data.name, data.value);
		});
	}

	AysChartBuilder.prototype.initDbImport = function(){
		var _this = this;
		_this.gSheetcolumnOrder = _this.chartSourceData.gsheet_column_ordering;

		_this.initDbImportComponent();

		_this.$el.find('#ays-chart-query-fetch').on('click', function(e){
			e.preventDefault();
			_this.fetchDBData( true );
		});

		_this.$el.find('#ays-chart-query-show-on-chart').on( 'click', function(e){
			e.preventDefault();

			if( _this.chartTempData ){
				if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
					_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'org_chart') {
					_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'bubble_chart') {
					_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'scatter_chart') {
					_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'table_chart') {
					_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'timeline_chart') {
					_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'candlestick_chart') {
					_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'gantt_chart') {
					_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'sankey_diagram') {
					_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
				} else if (_this.chartType == 'treemap') {
					_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
				} else if (_this.chartType == 'word_tree') {
					_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
				} else {
					_this.chartTempData = _this.chartConvertData( _this.chartTempData );
				}

				if (_this.chartType == 'candlestick_chart') {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
				} else {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
				}

				_this.updateChartData( _this.chartData );
				
				_this.chartDataArray = _this.chartTempData;
				_this.chartTempData = null;
			}else{
				_this.fetchDBData( false, true );
			}

		} );

		_this.$el.find('#ays-chart-query-save').on( 'click', function(e){
			e.preventDefault();

			_this.$el.find('.db-wizard-success').empty();
			_this.$el.find('.db-wizard-error').empty();

			// submit only if a query has been provided.
			if( _this.$el.find('#db-query-form .ays-chart-db-query').val().length > 0 ){
				_this.startAjax( _this.$el.find('#ays-chart-db-query') );

				$.ajax({
					url: ajaxurl,
					method: 'post',
					dataType: 'json',
					data: {
						'action': _this.ajaxAction,
						'function': window.aysChartBuilderChartSettings.ajax['actions']['db_save_data'],
						'security': window.aysChartBuilderChartSettings.ajax['nonces']['db_save_data'],
						'params': {
							query: _this.$el.find('#db-query-form [name="query"]').val(),
							chart_id: _this.$el.find('#db-query-form [name="chart_id"]').val(),
						}
					},
					success: function( response ){
						if( response.success ){
							_this.$el.find('.db-wizard-success').html( response.data.msg );
							_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('import_from_db');
						}else{
							_this.$el.find('.db-wizard-error').html( response.data.msg );
						}
					},
					complete: function(){
						_this.endAjax( _this.$el.find('#ays-chart-db-query') );
					}
				});
			}else{
				_this.$el.find('#ays-chart-db-query').unlock();
			}
		});
	}

	AysChartBuilder.prototype.fetchDBData = function( openModal = false, showOnChart = false ){
		var _this = this;
		_this.$el.trigger('ays-chart:db:query:update', {});

		if( _this.$el.find('.ays-chart-db-query').val() === '' ){
			return;
		}

		_this.startAjax( _this.$el.find('#ays-chart-db-query') );

		var modal = $(document).find('#ays-chart-db-query-results');

		_this.$el.find('.db-wizard-results').empty();
		_this.$el.find('.db-wizard-success').empty();
		_this.$el.find('.db-wizard-error').empty();

		$.ajax({
			url: ajaxurl,
			method: 'post',
			dataType: 'json',
			data: {
				'action': _this.ajaxAction,
				'function': window.aysChartBuilderChartSettings.ajax['actions']['db_get_data'],
				'security': window.aysChartBuilderChartSettings.ajax['nonces']['db_get_data'],
				'params': {
					query: _this.$el.find('#db-query-form [name="query"]').val(),
					chart_id: _this.$el.find('#db-query-form [name="chart_id"]').val(),
				}
			},
			success: function( response ){
				if( response.success ){
					modal.find('.db-wizard-results').html( response.data.table );
					modal.find('#results').DataTable({
						"paging": true
					});
					modal.find('#results').parent().addClass('ays-db-results-wrap');

					if( openModal === true ) {
						modal.aysModal('show');
					}

					_this.chartTempData = response.data.data ? response.data.data : null;

					if( showOnChart === true ) {
						if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
							_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'org_chart') {
							_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'bubble_chart') {
							_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'scatter_chart') {
							_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'table_chart') {
							_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'timeline_chart') {
							_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'candlestick_chart') {
							_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'gantt_chart') {
							_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'sankey_diagram') {
							_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
						} else if (_this.chartType == 'treemap') {
							_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
						} else if (_this.chartType == 'word_tree') {
							_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
						} else {
							_this.chartTempData = _this.chartConvertData( _this.chartTempData );
						}

						if (_this.chartType == 'candlestick_chart') {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
						} else {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
						}

						_this.updateChartData( _this.chartData );

						_this.chartDataArray = _this.chartTempData;
						_this.chartTempData = null;
					}
				}else{
					modal.find('ays-close').trigger('click');
					_this.$el.find('.db-wizard-error').html( response.data.msg );
				}
			},
			complete: function(){
				_this.endAjax( _this.$el.find('#ays-chart-db-query') );
			}
		});
	}

	AysChartBuilder.prototype.initExternalDbImportComponent = function() {
		var _this = this;
		var code_mirror = wp.CodeMirror || CodeMirror;	
		var cm = code_mirror.fromTextArea(_this.$el.find('.ays-chart-external-db-query').get(0), {
			value: _this.$el.find('.ays-chart-external-db-query').val(),
			autofocus: false,
			mode: 'text/x-mysql',
			lineWrapping: true,
			dragDrop: false,
			matchBrackets: true,
			autoCloseBrackets: true,
			extraKeys: {"Ctrl-Space": "autocomplete"}
		});

		_this.$el.on('ays-chart:external-db:query:focus', function(event, data) {
			cm.refresh();
		});

		cm.on('inputRead', function(x, y) {
			cm.save();
		});

		_this.$el.on('ays-chart:external-db:query:update', function(event, data) {
			cm.save();
		});

		_this.$el.on('ays-chart:external-db:query:setvalue', function(event, data) {
			cm.setValue(data.value);
			cm.clearHistory();
			cm.refresh();
		});

		_this.$el.on('ays-chart:external-db:query:changeoption', function(event, data) {
			cm.setOption(data.name, data.value);
		});
	};

	AysChartBuilder.prototype.initExternalDbImport = function() {
		var _this = this;
		_this.gSheetcolumnOrder = _this.chartSourceData.gsheet_column_ordering;

		_this.initExternalDbImportComponent();

		_this.$el.find('#ays-external-db-query-fetch').on('click', function(e) {
			e.preventDefault();
			_this.fetchExternalDBData(true);
		});
	
		_this.$el.find('#ays-external-db-query-show-on-chart').on('click', function(e) {
			e.preventDefault();

			if( _this.chartTempData ){
				if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
					_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'org_chart') {
					_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'bubble_chart') {
					_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'scatter_chart') {
					_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'table_chart') {
					_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'timeline_chart') {
					_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'candlestick_chart') {
					_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'gantt_chart') {
					_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'sankey_diagram') {
					_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
				} else if (_this.chartType == 'treemap') {
					_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
				} else if (_this.chartType == 'word_tree') {
					_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
				} else {
					_this.chartTempData = _this.chartConvertData( _this.chartTempData );
				}

				if (_this.chartType == 'candlestick_chart') {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
				} else {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
				}

				_this.updateChartData( _this.chartData );
				
				_this.chartDataArray = _this.chartTempData;
				_this.chartTempData = null;
			} else {
				_this.fetchExternalDBData(false, true);
			}
		});

		_this.$el.find('#ays-external-db-query-save').on('click', function(e) {
			e.preventDefault();

			_this.$el.find('.external-db-wizard-success').empty();
			_this.$el.find('.external-db-wizard-error').empty();

			var useCustomDbSettings = $(document).find('#ays_use_chart_specific_db').is(':checked');
			var customSettings = {
				host: $(document).find('#ays-external-db-host').val(),
				db_name: $(document).find('#ays-external-db-name').val(),
				user: $(document).find('#ays-external-db-user').val(),
				password: $(document).find('#ays-external-db-password').val(),
				port: $(document).find('#ays-external-db-port').val() ? $(document).find('#ays-external-db-port').val() : '3306',
			}

			if (_this.$el.find('.ays-chart-external-db-query').val().length > 0) {
				_this.startAjax(_this.$el.find('#ays-external-db-query'));

				$.ajax({
					url: ajaxurl,
					method: 'post',
					dataType: 'json',
					data: {
						'action': _this.ajaxAction,
						'function': window.aysChartBuilderChartSettings.ajax['actions']['external_db_save_data'],
						'security': window.aysChartBuilderChartSettings.ajax['nonces']['external_db_save_data'],
						'use_custom_db_settings': useCustomDbSettings,
						'custom_settings': customSettings,
						'params': {
							query: _this.$el.find('.ays-chart-external-db-query').val(),
							chart_id: _this.$el.find('#external-db-query-form [name="chart_id"]').val(),
						}
					},
					success: function(response) {
						if (response.success) {
							_this.$el.find('.external-db-wizard-success').html(response.data.msg);
							_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('import_from_external_db');
						} else {
							_this.$el.find('.external-db-wizard-error').html(response.data.msg);
						}
					},
					complete: function() {
						_this.endAjax(_this.$el.find('#ays-external-db-query'));
					}
				});
			} else {
				_this.$el.find('#ays-external-db-query').unlock();
			}
		});
	};
	
	AysChartBuilder.prototype.fetchExternalDBData = function(openModal = false, showOnChart = false) {
		var _this = this;
		_this.$el.trigger('ays-chart:external-db:query:update', {});

		if (_this.$el.find('.ays-chart-external-db-query').val() === '') {
			return;
		}

		_this.startAjax(_this.$el.find('#ays-external-db-query'));

		var modal = $(document).find('#ays-chart-db-query-results');

		var useCustomDbSettings = $(document).find('#ays_use_chart_specific_db').is(':checked');
		
		var customSettings = {
			host: $(document).find('#ays-external-db-host').val(),
			db_name: $(document).find('#ays-external-db-name').val(),
			user: $(document).find('#ays-external-db-user').val(),
			password: $(document).find('#ays-external-db-password').val(),
			port: $(document).find('#ays-external-db-port').val() ? $(document).find('#ays-external-db-port').val() : '3306',
		}
		
		$.ajax({
			url: ajaxurl,
			method: 'post',
			dataType: 'json',
			data: {
				'action': _this.ajaxAction,
				'function': window.aysChartBuilderChartSettings.ajax['actions']['external_db_get_data'],
				'security': window.aysChartBuilderChartSettings.ajax['nonces']['external_db_get_data'],
				'use_custom_db_settings': useCustomDbSettings,
				'custom_settings': customSettings,
				'params': {
					query: _this.$el.find('.ays-chart-external-db-query').val(),
					chart_id: _this.$el.find('#external-db-query-form [name="chart_id"]').val(),
				}
			},
			success: function(response) {
				if( response.success ){
					modal.find('.db-wizard-results').html( response.data.table );
					modal.find('#results').DataTable({
						"paging": true
					});
					modal.find('#results').parent().addClass('ays-db-results-wrap');

					if( openModal === true ) {
						modal.aysModal('show');
					}
					
					_this.chartTempData = response.data.data ? response.data.data : null;

					if( showOnChart === true ) {
						if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
							_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'org_chart') {
							_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'bubble_chart') {
							_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'scatter_chart') {
							_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'table_chart') {
							_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'timeline_chart') {
							_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'candlestick_chart') {
							_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'gantt_chart') {
							_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'sankey_diagram') {
							_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
						} else if (_this.chartType == 'treemap') {
							_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
						} else if (_this.chartType == 'word_tree') {
							_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
						} else {
							_this.chartTempData = _this.chartConvertData( _this.chartTempData );
						}

						if (_this.chartType == 'candlestick_chart') {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
						} else {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
						}

						_this.updateChartData( _this.chartData );

						_this.chartDataArray = _this.chartTempData;
						_this.chartTempData = null;
					}
				}else{
					modal.find('ays-close').trigger('click');
					_this.$el.find('.external-db-wizard-error').html( response.data.msg );
					_this.endAjax( _this.$el.find('#ays-external-db-query') );
				}
			},
			complete: function(){
				_this.endAjax( _this.$el.find('#ays-external-db-query') );
			}
		});
	};

	AysChartBuilder.prototype.initGoogleSheetImport = function(){
		var _this = this;

		_this.$el.find('#ays-chart-gsheet-fetch').on('click', function(e){
			e.preventDefault();
			_this.fetchGoogleSheetData( true );
		});

		_this.$el.find('#ays-chart-gsheet-show-on-chart').on( 'click', function(e){
			e.preventDefault();

			if( _this.chartTempData ){
				if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
					_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'org_chart') {
					_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'bubble_chart') {
					_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'scatter_chart') {
					_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'table_chart') {
					_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'timeline_chart') {
					_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'candlestick_chart') {
					_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'gantt_chart') {
					_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'sankey_diagram') {
					_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
				} else if (_this.chartType == 'treemap') {
					_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
				} else if (_this.chartType == 'word_tree') {
					_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
				} else {
					_this.chartTempData = _this.chartConvertData( _this.chartTempData );
				}
				
				if (_this.chartType == 'candlestick_chart') {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
				} else {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
				}

				_this.updateChartData( _this.chartData );
				_this.chartDataArray = _this.chartTempData;
				_this.chartTempData = null;
			}else{
				_this.fetchGoogleSheetData( false, true, false );
			}

		} );

		_this.$el.find('#ays-chart-gsheet-save').on( 'click', function(e){
			e.preventDefault();

			_this.$el.find('.ays-chart-google-sheet-success').empty();
			_this.$el.find('.ays-chart-google-sheet-error').empty();
			var gSpreadsheetSelect = _this.$el.find('#ays-chart-google-sheet-form .'+ _this.htmlClassPrefix +'google-sheet-select');

			// submit only if a query has been provided.
			if( gSpreadsheetSelect.val().length > 0 ){
				_this.startAjax( _this.$el.find('#ays-chart-google-sheet-form') );
				var columnOrder = _this.gSheetcolumnOrder;

				$.ajax({
					url: ajaxurl,
					method: 'post',
					dataType: 'json',
					data: {
						'action': _this.ajaxAction,
						'function': window.aysChartBuilderChartSettings.ajax['actions']['gsheet_save_data'],
						'security': window.aysChartBuilderChartSettings.ajax['nonces']['gsheet_save_data'],
						'spreadsheet_id': gSpreadsheetSelect.val(),
						'chart_id': gSpreadsheetSelect.data('chartId'),
						'column_order': columnOrder,
					},
					success: function( response ){
						if( response.success ){
							_this.$el.find('.ays-chart-google-sheet-success').html( response.data.msg );
							_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('google_sheet');
						}else{
							_this.$el.find('.ays-chart-google-sheet-error').html( response.data.msg );
						}
					},
					complete: function(){
						_this.endAjax( _this.$el.find('#ays-chart-google-sheet-form') );
					}
				});
			}else{
				_this.$el.find('#ays-chart-google-sheet-form').unlock();
			}
		});

		$(document).on('ays-chart:modal:close', function (){
			_this.chartTempData = null;
		});

		_this.$el.find('#ays-chart-gsheet-columns').on('click', function(e){
			e.preventDefault();
			_this.fetchGoogleSheetData(false, false, true);
		});

		_this.$el.find('select#'+ _this.htmlNamePrefix +'google_sheet_id_select').on('change', function() {
			_this.gSheetcolumnOrder = [];
		});

		$(document).find('#ays-chart-gsheet-columns-apply').on('click', function(){
			var columnOrder = [];
			var checkedCount = 0;

			$(document).find('.ays-chart-gsheet-columns-sortable li').each(function() {
				var columnNumber = $(this).find('input[type="hidden"]').val();
				var isEnabled = $(this).find('input[type="checkbox"]').prop('checked');

				columnOrder.push({
					columnNumber: columnNumber,
					enabled: isEnabled
				});

				if (isEnabled) {
					checkedCount++;
				}
			});

			if (checkedCount < 2) {
				$(document).find('.ays-chart-gsheet-columns-sortable li input[type="checkbox"]').prop('checked', false);

				for (var i = 0; i < 2; i++) {
					if(i < columnOrder.length) {
						$(document).find('.ays-chart-gsheet-columns-sortable li input[type="checkbox"]').eq(i).prop('checked', true);
						columnOrder[i].enabled = true;
					}
				}
			}

			_this.gSheetcolumnOrder = columnOrder;

			var columnsModal = $(document).find('#ays-chart-gsheet-columns-modal');
			columnsModal.aysModal('hide');
		});
	}

	AysChartBuilder.prototype.fetchGoogleSheetData = function( openModal = false, showOnChart = false, openColumnsModal = false ){
		var _this = this;

		if( _this.$el.find('.'+ _this.htmlClassPrefix +'google-sheet-select').val() === '' ){
			return;
		}

		_this.startAjax( _this.$el.find('#ays-chart-google-sheet-form') );

		var modal = $(document).find('#ays-chart-db-query-results');
		var columnsModal = $(document).find('#ays-chart-gsheet-columns-modal');

		_this.$el.find('.db-wizard-results').empty();
		_this.$el.find('.ays-chart-google-sheet-success').empty();
		_this.$el.find('.ays-chart-google-sheet-error').empty();

		$.ajax({
			url: ajaxurl,
			method: 'post',
			dataType: 'json',
			data: {
				'action': _this.ajaxAction,
				'function': window.aysChartBuilderChartSettings.ajax['actions']['gsheet_get_data'],
				'security': window.aysChartBuilderChartSettings.ajax['nonces']['gsheet_get_data'],
				'spreadsheet_id': _this.$el.find('#ays-chart-google-sheet-form [name="'+ _this.htmlNamePrefix +'google_sheet_id"]').val(),
			},
			success: function( response ){
				if( response.success ){
					modal.find('.db-wizard-results').html( response.data.table );
					modal.find('#results').DataTable({
						"paging": true
					});
					modal.find('#results').parent().addClass('ays-db-results-wrap');
					
					if( openModal === true ) {
						modal.aysModal('show');
					}

					_this.chartTempData = response.data.data ? response.data.data : null;
					if(openColumnsModal) {
						columnsModal.aysModal('show');

						// check if chartTempData not null, array and has elements
						let columns = ( _this.chartTempData && Array.isArray(_this.chartTempData) && _this.chartTempData[1] ) ? _this.chartTempData[1] : [];
						let columnsCount = columns.length;
						_this.generateColumnsContent(columnsCount, _this.gSheetcolumnOrder);

						return;
					}

					if( showOnChart === true ) {
						_this.chartTempData = _this.applyGSheetColumnOrder(_this.chartTempData, _this.gSheetcolumnOrder);
						if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
							_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'org_chart') {
							_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'bubble_chart') {
							_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'scatter_chart') {
							_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'table_chart') {
							_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'timeline_chart') {
							_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'candlestick_chart') {
							_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'gantt_chart') {
							_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'sankey_diagram') {
							_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
						} else if (_this.chartType == 'treemap') {
							_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
						} else if (_this.chartType == 'word_tree') {
							_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
						} else {
							_this.chartTempData = _this.chartConvertData( _this.chartTempData );
						}
						
						if (_this.chartType == 'candlestick_chart') {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
						} else {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
						}

						_this.updateChartData(_this.chartData);

						_this.chartDataArray = _this.chartTempData;
						_this.chartTempData = null;
					}
				}else{
					modal.find('ays-close').trigger('click');
					_this.$el.find('.ays-chart-google-sheet-error').html( response.data.msg );
				}
			},
			complete: function(){
				_this.endAjax( _this.$el.find('#ays-chart-google-sheet-form') );
			}
		});
	}

	AysChartBuilder.prototype.generateColumnsContent = function (columnsCount, storedColumnOrder){
		var _this = this;
		var columnsContainer = $(document).find('#ays-chart-gsheet-columns-modal .ays-chart-gsheet-columns-container');
		var columnsSortableContainer = columnsContainer.find('ul.ays-chart-gsheet-columns-sortable');
		var content = '';

		if (!columnsCount) {
			var emptyColumnsMessage = columnsContainer.find('.ays-chart-gsheet-no-columns-message');
			emptyColumnsMessage.removeClass('display_none');
			return;
		}

		var chartsWithTwoColumns = ['pie_chart', 'donut_chart', 'histogram', '3dpie_chart'];
		var maxColumns = 0;

		for (let i = 0; i < columnsCount; i++) {
			var checked = true;
			var columnIndex = i + 1;
			if (storedColumnOrder && storedColumnOrder.length > 0) {
				checked = storedColumnOrder[i] && (storedColumnOrder[i].enabled === 'true' || storedColumnOrder[i].enabled === true) ? true : false;
				columnIndex = storedColumnOrder[i] ? storedColumnOrder[i].columnNumber : i + 1;
			}

			if (chartsWithTwoColumns.includes(_this.chartType)) {
				if(maxColumns >= 2) {
					checked = false;
				} else if (checked) {
					maxColumns++;
				}
			}

			var columnName = (_this.chartTempData && Array.isArray(_this.chartTempData) && Array.isArray(_this.chartTempData[0]) && _this.chartTempData[0][columnIndex - 1]) ? _this.chartTempData[0][columnIndex - 1] : 'Column ' + columnIndex;

			content += '<li class="ays-user-page-option-row ui-state-default">';
				content += '<input type="hidden" value="' + columnIndex + '" name="ays_chart_gsheet_columns_order[]"/>';
				content += '<input type="checkbox" id="ays_chart_gsheet_columns_show_' + columnIndex + '" class="ays-checkbox-input"';
				content += checked ? ' checked />' : '/>';
				content += '<label for="ays_chart_gsheet_columns_show_' + columnIndex + '"> ' + columnName + ' </label>';
			content += '</li>';
		}

		columnsSortableContainer.html(content);

	}

	AysChartBuilder.prototype.applyGSheetColumnOrder = function (chartData, columnOrder) {
		if (!columnOrder || columnOrder.length === 0) {
			return chartData;
		}

		var reorderedData = [];
		for (var i = 0; i < chartData.length; i++) {
			var newRow = [];
			for (var j = 0; j < columnOrder.length; j++) {
				var columnIndex = columnOrder[j].columnNumber - 1;
				if (columnOrder[j].enabled) {
					newRow.push(chartData[i][columnIndex]);
				}
			}
			reorderedData.push(newRow);
		}

		return reorderedData;
	}

	AysChartBuilder.prototype.updateImportFileFormat = function (option){
		var _this = this;
		var format = option.val();
		var input = $(document).find('#'+_this.htmlClassPrefix+'import-files-input');
		input.attr('accept', '.'+format);
	}

	AysChartBuilder.prototype.initFileImport = function(){
		var _this = this;

		_this.$el.find('#ays-chart-file-import-fetch').on('click', function(e) {
			e.preventDefault();
			_this.fetchFileData( true );
		});

		_this.$el.find('#ays-chart-file-import-show-on-chart').on( 'click', function(e) {
			e.preventDefault();

			if ( _this.chartTempData ) {
				if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
					_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'org_chart') {
					_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'bubble_chart') {
					_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'scatter_chart') {
					_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'table_chart') {
					_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'timeline_chart') {
					_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'candlestick_chart') {
					_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'gantt_chart') {
					_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'sankey_diagram') {
					_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
				} else if (_this.chartType == 'treemap') {
					_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
				} else if (_this.chartType == 'word_tree') {
					_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
				} else {
					_this.chartTempData = _this.chartConvertData( _this.chartTempData );
				}
				
				if (_this.chartType == 'candlestick_chart') {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
				} else {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
				}

				_this.chartTempData = _this.chartConvertData( _this.chartTempData );

				_this.chartDataArray = _this.chartTempData;
				_this.chartTempData = null;
			} else {
				_this.fetchFileData( false, true );
			}

		});

		_this.$el.find('#ays-chart-file-import-save').on( 'click', function(e) {
			e.preventDefault();

			_this.$el.find('.ays-chart-file-import-success').empty();
			_this.$el.find('.ays-chart-file-import-error').empty();

			var formData = new FormData();
			var fileData = $(document).find('#'+_this.htmlClassPrefix+'import-files-input').prop('files')[0];
			var chart_id = $(document).find('#' + _this.htmlClassPrefix + 'chart-id').val();

			if ( typeof(fileData) != "undefined" ) {
				_this.startAjax( _this.$el.find('.ays-chart-file-import-form') );
				
				formData.append('file_data', fileData);
				formData.append('chart_id', chart_id);
				formData.append('action', window.aysChartBuilderChartSettings.ajax['actions']['file_import_save_data']);

				// Get a reference to our file input
				var fileInput = $(document).find('#'+_this.htmlClassPrefix+'import-files-input');

				$.ajax({
					url: window.aysChartBuilderChartSettings.ajax['url'],
					method: 'post',
					dataType : 'json',
					data: formData,
					contentType: false,
					processData: false,
					success: function( response ) {
						var data = JSON.parse(response.data);
						if ( response.success ) {
							_this.$el.find('.ays-chart-file-import-success').html( data.msg );
							_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('file_import');
						} else {
							_this.$el.find('.ays-chart-file-import-error').html( data.msg );
						}
					},
					complete: function() {
						_this.endAjax( _this.$el.find('.ays-chart-file-import-form') );
					}
				});
			} else {
				_this.$el.find('.ays-chart-file-import-form').unlock();
			}
		});

		$(document).on('ays-chart:modal:close', function () {
			_this.chartTempData = null;
		});
	}

	AysChartBuilder.prototype.fetchFileData = function( openModal = false, showOnChart = false ){
		var _this = this;

		var formData = new FormData();
		var fileData = $(document).find('#'+_this.htmlClassPrefix+'import-files-input').prop('files')[0];

		if (typeof(fileData) == 'undefined') {
			return;
		}

		formData.append('file_data', fileData);
		formData.append('action', window.aysChartBuilderChartSettings.ajax['actions']['file_import_get_data']);
		// formData.append('nonces', window.aysChartBuilderChartSettings.ajax['nonces']['file_import_get_data']);

		_this.startAjax( _this.$el.find('.ays-chart-file-import-form') );

		var modal = $(document).find('#ays-chart-db-query-results');

		_this.$el.find('.db-wizard-results').empty();
		_this.$el.find('.ays-chart-file-import-success').empty();
		_this.$el.find('.ays-chart-file-import-error').empty();

		$.ajax({
			url: window.aysChartBuilderChartSettings.ajax['url'],
			method: 'post',
			dataType : 'json',
			data: formData,
			contentType: false,
			processData: false,
			success: function( response ){
				var data = JSON.parse(response.data);
				if( response.success ){
					modal.find('.db-wizard-results').html( data.table );
					modal.find('#results').DataTable({
						"paging": true
					});
					modal.find('#results').parent().addClass('ays-db-results-wrap');
					
					if( openModal === true ) {
						modal.aysModal('show');
					}

					_this.chartTempData = data.data ? data.data : null;

					if( showOnChart === true ) {
						if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
							_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'org_chart') {
							_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'bubble_chart') {
							_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'scatter_chart') {
							_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'table_chart') {
							_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'timeline_chart') {
							_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'candlestick_chart') {
							_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'gantt_chart') {
							_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'sankey_diagram') {
							_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
						} else if (_this.chartType == 'treemap') {
							_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
						} else if (_this.chartType == 'word_tree') {
							_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
						} else {
							_this.chartTempData = _this.chartConvertData( _this.chartTempData );
						}
						
						if (_this.chartType == 'candlestick_chart') {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
						} else {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
						}

						_this.updateChartData(_this.chartData);

						_this.chartDataArray = _this.chartTempData;
						_this.chartTempData = null;
					}
				} else {
					modal.find('ays-close').trigger('click');
					_this.$el.find('.ays-chart-file-import-error').html( data.msg );
				}
			},
			complete: function(){
				_this.endAjax( _this.$el.find('.ays-chart-file-import-form') );
			}
		});
	}

	AysChartBuilder.prototype.initWoocommerceImport = function(){
		var _this = this;

		_this.$el.find('#ays-chart-woocommerce-datas-fetch').on('click', function(e){
			e.preventDefault();
			
			var select_query = $(document).find('#'+_this.htmlClassPrefix+'woocommerce-datas-select').val();
			if (select_query == "") {
				return;
			}

			_this.fetchWoocommerceData( true );
		});
		_this.$el.find('#ays-chart-woocommerce-datas-show-on-chart').on( 'click', function(e){
			e.preventDefault();
			
			var select_query = $(document).find('#'+_this.htmlClassPrefix+'woocommerce-datas-select').val();

			if (select_query == "") {
				return;
			}

			if( _this.chartTempData ){
				if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
					_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'org_chart') {
					_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'bubble_chart') {
					_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'scatter_chart') {
					_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'table_chart') {
					_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'timeline_chart') {
					_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'candlestick_chart') {
					_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'gantt_chart') {
					_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'sankey_diagram') {
					_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
				} else if (_this.chartType == 'treemap') {
					_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
				} else if (_this.chartType == 'word_tree') {
					_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
				} else {
					_this.chartTempData = _this.chartConvertData( _this.chartTempData );
				}
				
				if (_this.chartType == 'candlestick_chart') {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
				} else {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
				}
				_this.chartTempData = _this.chartConvertData( _this.chartTempData );

				_this.updateChartData( _this.chartData );

				_this.chartDataArray = _this.chartTempData;
				_this.chartTempData = null;
			}else{
				_this.fetchWoocommerceData( false, true );
			}

		} );

		_this.$el.find('#ays-chart-woocommerce-datas-save').on( 'click', function(e) {
			e.preventDefault();
			
			var select_query = $(document).find('#'+_this.htmlClassPrefix+'woocommerce-datas-select').val();
			if (select_query == "") {
				return;
			}
			
			_this.$el.find('.ays-chart-woocommerce-datas-success').empty();
			_this.$el.find('.ays-chart-woocommerce-datas-error').empty();

			var chart_id = $(document).find('#' + _this.htmlClassPrefix + 'chart-id').val();

			_this.startAjax( _this.$el.find('.ays-chart-woocommerce-datas-form') );
			
			$.ajax({
				url: window.aysChartBuilderChartSettings.ajax['url'],
				method: 'post',
				dataType: 'json',
				data: {
					'action': _this.ajaxAction,
					'function': window.aysChartBuilderChartSettings.ajax['actions']['woocommerce_save_data'],
					'security': window.aysChartBuilderChartSettings.ajax['nonces']['woocommerce_save_data'],
					'params': {
						query : select_query,
						chart_id: chart_id,
					}
				},
				success: function( response ) {
					var data = response.data;
					if ( response.success ) {
						_this.$el.find('.ays-chart-woocommerce-datas-success').html( data.msg );
						_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('woocommerce_data');

					} else {
						_this.$el.find('.ays-chart-woocommerce-datas-error').html( data.msg );
						_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('manual');
					}
				},
				complete: function() {
					_this.endAjax( _this.$el.find('.ays-chart-woocommerce-datas-form') );
				}
			});
		});

		$(document).on('ays-chart:modal:close', function () {
			_this.chartTempData = null;
		});
	}

	AysChartBuilder.prototype.fetchWoocommerceData = function( openModal = false, showOnChart = false ){
		var _this = this;
		
		_this.$el.trigger('ays-chart:db:query:update', {});

		var chart_id = $(document).find('.' + _this.htmlClassPrefix + 'chart-id').val();

		_this.startAjax( _this.$el.find('#ays-chart-woocommerce-datas-form') );

		var modal = $(document).find('#ays-chart-db-query-results');

		_this.$el.find('.db-wizard-results').empty();
		_this.$el.find('.ays-chart-woocommerce-datas-success').empty();
		_this.$el.find('.ays-chart-woocommerce-datas-error').empty();
		
		var query = $(document).find('#'+_this.htmlClassPrefix+'woocommerce-datas-select').find('option:selected').val();

		$.ajax({
			url: ajaxurl,
			method: 'post',
			dataType: 'json',
			data: {
				'action': _this.ajaxAction,
				'function': window.aysChartBuilderChartSettings.ajax['actions']['woocommerce_get_data'],
				'security': window.aysChartBuilderChartSettings.ajax['nonces']['woocommerce_get_data'],
				'params': {
					query : query,
					chart_id: chart_id,
				}
			},
			success: function( response ){
				if( response.success ){
					modal.find('.db-wizard-results').html( response.data.table );
					modal.find('#results').DataTable({
						"paging": true
					});
					modal.find('#results').parent().addClass('ays-db-results-wrap');
					
					if( openModal === true ) {
						modal.aysModal('show');
					}

					_this.chartTempData = response.data.data ? response.data.data : null;
					if( showOnChart === true ) {
						if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
							_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'org_chart') {
							_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'bubble_chart') {
							_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'scatter_chart') {
							_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'table_chart') {
							_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'timeline_chart') {
							_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'candlestick_chart') {
							_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'gantt_chart') {
							_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'sankey_diagram') {
							_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
						} else if (_this.chartType == 'treemap') {
							_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
						} else if (_this.chartType == 'word_tree') {
							_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
						} else {
							_this.chartTempData = _this.chartConvertData( _this.chartTempData );
						}
						
						if (_this.chartType == 'candlestick_chart') {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
						} else {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
						}

						_this.updateChartData(_this.chartData);

						_this.chartDataArray = _this.chartTempData;
						_this.chartTempData = null;
					}
				}else{
					modal.find('ays-close').trigger('click');
					_this.$el.find('.ays-chart-woocommerce-datas-error').html( response.data.msg );
				}
			},
			complete: function(){
				_this.endAjax( _this.$el.find('#ays-chart-woocommerce-datas-form') );
			}
		});
	}

	AysChartBuilder.prototype.initQuizDBImport = function(){
		var _this = this;

		_this.$el.find('#ays-chart-quiz-maker-fetch').on('click', function(e){
			e.preventDefault();

			var select_query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').val();
			if (select_query == "") {
				return;
			}
			_this.fetchQuizData( true );
		});

		_this.$el.find('#ays-chart-quiz-maker-show-on-chart').on( 'click', function(e){
			e.preventDefault();

			var select_query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').val();
			if (select_query == "") {
				return;
			}

			if( _this.chartTempData ){
				if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
					_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'org_chart') {
					_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'bubble_chart') {
					_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'scatter_chart') {
					_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'table_chart') {
					_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'timeline_chart') {
					_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'candlestick_chart') {
					_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'gantt_chart') {
					_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
				} else if (_this.chartType == 'sankey_diagram') {
					_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
				} else if (_this.chartType == 'treemap') {
					_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
				} else if (_this.chartType == 'word_tree') {
					_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
				} else {
					_this.chartTempData = _this.chartConvertData( _this.chartTempData );
				}
				
				if (_this.chartType == 'candlestick_chart') {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
				} else {
					_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
				}

				_this.updateChartData( _this.chartData );

				_this.chartDataArray = _this.chartTempData;
				_this.chartTempData = null;
			}else{
				_this.fetchQuizData( false, true );
			}

		} );

		_this.$el.find('#ays-chart-quiz-maker-save').on( 'click', function(e){
			e.preventDefault();

			var select_query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').val();
			if (select_query == "") {
				return;
			}

			_this.$el.find('.ays-chart-quiz-maker-success').empty();
			_this.$el.find('.ays-chart-quiz-maker-error').empty();

			var chart_id = $(document).find('.' + _this.htmlClassPrefix + 'chart-id').val();
			var query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').find('option:selected').val();
			var selectQuizSelectDisplay = $(document).find('.'+_this.htmlClassPrefix+'select-quiz-maker-quiz-container').css('display');
			var selectCatSelectDisplay = $(document).find('.'+_this.htmlClassPrefix+'select-quiz-maker-category-container').css('display');
			var selectQuestionCatSelectDisplay = $(document).find('.'+_this.htmlClassPrefix+'select-quiz-maker-question-category-container').css('display');
			var quizID = null;
			var quiz_cat_id = null;
			var quiz_question_cat_id =null;
			if (selectQuizSelectDisplay != 'none') {
				quizID = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz').find('option:selected').val();
				if (quizID == 0 && query != 'q13') {
					_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuiz );
					return;
				} else if (quizID == 0 && query == 'q13') {
					quiz_question_cat_id = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-question-category').find('option:selected').val();
					if (quiz_question_cat_id == 0) {
						_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuizAndQuestionCat );
						return;
					}
				}
			}
			if (selectCatSelectDisplay != 'none') {
				quiz_cat_id = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz-category').find('option:selected').val();
				if (quiz_cat_id == 0) {
					_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuizCat );
					return;
				}
			}
			if (selectQuestionCatSelectDisplay != 'none') {
				quiz_question_cat_id = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-question-category').find('option:selected').val();
				if (quiz_question_cat_id == 0 && query != 'q13') {
					_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuestionCat );
					return;
				} else if (quiz_question_cat_id == 0 && query == 'q13') {
					quizID = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz').find('option:selected').val();
					if (quizID == 0) {
						_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuizAndQuestionCat );
						return;
					}
				}
			}

			// submit only if a query has been provided.
			if( query.length > 0 ){
				_this.startAjax( _this.$el.find('#ays-chart-quiz-maker-form') );

				$.ajax({
					url: ajaxurl,
					method: 'post',
					dataType: 'json',
					data: {
						'action': _this.ajaxAction,
						'function': window.aysChartBuilderChartSettings.ajax['actions']['quiz_maker_save_data'],
						'security': window.aysChartBuilderChartSettings.ajax['nonces']['quiz_maker_save_data'],
						'params': {
							query: query,
							quizID: quizID,
							quiz_cat_id: quiz_cat_id,
							quiz_question_cat_id: quiz_question_cat_id,
							chart_id: chart_id,
						}
					},
					success: function( response ){
						if( response.success ){
							_this.$el.find('.ays-chart-quiz-maker-success').html( response.data.msg );
							_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('quiz_maker');
						}else{
							_this.$el.find('.ays-chart-quiz-maker-error').html( response.data.msg );
							_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('manual');
						}
					},
					complete: function(){
						_this.endAjax( _this.$el.find('#ays-chart-quiz-maker-form') );
					}
				});
			}else{
				_this.$el.find('#ays-chart-quiz-maker-form').unlock();
				_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('manual');
			}
		});

		$(document).on('ays-chart:modal:close', function (){
			_this.chartTempData = null;
		});
	}

	AysChartBuilder.prototype.fetchQuizData = function( openModal = false, showOnChart = false ){
		var _this = this;
		_this.$el.trigger('ays-chart:db:query:update', {});

		var chart_id = $(document).find('.' + _this.htmlClassPrefix + 'chart-id').val();
		var query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').find('option:selected').val();
		var selectQuizSelectDisplay = $(document).find('.'+_this.htmlClassPrefix+'select-quiz-maker-quiz-container').css('display');
		var selectCatSelectDisplay = $(document).find('.'+_this.htmlClassPrefix+'select-quiz-maker-category-container').css('display');
		var selectQuestionCatSelectDisplay = $(document).find('.'+_this.htmlClassPrefix+'select-quiz-maker-question-category-container').css('display');
		var quizID = null;
		var quiz_cat_id = null;
		var quiz_question_cat_id =null;
		if (selectQuizSelectDisplay != 'none') {
			quizID = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz').find('option:selected').val();
			if (quizID == 0 && query != 'q13') {
				_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuiz );
				return;
			} else if (quizID == 0 && query == 'q13') {
				quiz_question_cat_id = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-question-category').find('option:selected').val();
				if (quiz_question_cat_id == 0) {
					_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuizAndQuestionCat );
					return;
				}
			}
		}
		if (selectCatSelectDisplay != 'none') {
			quiz_cat_id = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz-category').find('option:selected').val();
			if (quiz_cat_id == 0) {
				_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuizCat );
				return;
			}
		}
		if (selectQuestionCatSelectDisplay != 'none') {
			quiz_question_cat_id = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-question-category').find('option:selected').val();
			if (quiz_question_cat_id == 0 && query != 'q13') {
				_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuestionCat );
				return;
			} else if (quiz_question_cat_id == 0 && query == 'q13') {
				quizID = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz').find('option:selected').val();
				if (quizID == 0) {
					_this.$el.find('.ays-chart-quiz-maker-error').html( aysChartBuilderAdmin.emptyQuizAndQuestionCat );
					return;
				}
			}
		}

		if (query.length == 0) {
			return;
		}

		_this.startAjax( _this.$el.find('#ays-chart-quiz-maker-form') );

		var modal = $(document).find('#ays-chart-db-query-results');

		_this.$el.find('.db-wizard-results').empty();
		_this.$el.find('.ays-chart-quiz-maker-success').empty();
		_this.$el.find('.ays-chart-quiz-maker-error').empty();

		$.ajax({
			url: ajaxurl,
			method: 'post',
			dataType: 'json',
			data: {
				'action': _this.ajaxAction,
				'function': window.aysChartBuilderChartSettings.ajax['actions']['quiz_maker_get_data'],
				'security': window.aysChartBuilderChartSettings.ajax['nonces']['quiz_maker_get_data'],
				'params': {
					query: query,
					quizID: quizID,
					quiz_cat_id: quiz_cat_id,
					quiz_question_cat_id: quiz_question_cat_id,
					chart_id: chart_id,
				}
			},
			success: function( response ){
				if( response.success ){
					modal.find('.db-wizard-results').html( response.data.table );
					modal.find('#results').DataTable({
						"paging": true
					});
					modal.find('#results').parent().addClass('ays-db-results-wrap');
					
					if( openModal === true ) {
						modal.aysModal('show');
					}

					_this.chartTempData = response.data.data ? response.data.data : null;

					if( showOnChart === true ) {
						if (_this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'line_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
							_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'org_chart') {
							_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'bubble_chart') {
							_this.chartTempData = _this.bubbleChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'scatter_chart') {
							_this.chartTempData = _this.scatterChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'table_chart') {
							_this.chartTempData = _this.tableChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'timeline_chart') {
							_this.chartTempData = _this.timelineChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'candlestick_chart') {
							_this.chartTempData = _this.candlestickChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'gantt_chart') {
							_this.chartTempData = _this.ganttChartConvertData( _this.chartTempData );
						} else if (_this.chartType == 'sankey_diagram') {
							_this.chartTempData = _this.sankeyDiagramConvertData( _this.chartTempData );
						} else if (_this.chartType == 'treemap') {
							_this.chartTempData = _this.treemapConvertData( _this.chartTempData );
						} else if (_this.chartType == 'word_tree') {
							_this.chartTempData = _this.wordTreeChartConvertData( _this.chartTempData );
						} else {
							_this.chartTempData = _this.chartConvertData( _this.chartTempData );
						}
						
						if (_this.chartType == 'candlestick_chart') {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData, true );
						} else {
							_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );
						}

						_this.updateChartData(_this.chartData);

						_this.chartDataArray = _this.chartTempData;
						_this.chartTempData = null;
					}
				}else{
					modal.find('ays-close').trigger('click');
					_this.$el.find('.ays-chart-quiz-maker-error').html( response.data.msg );
					_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('manual');
				}
			},
			complete: function(){
				_this.endAjax( _this.$el.find('#ays-chart-quiz-maker-form') );
			}
		});
	}

	AysChartBuilder.prototype.startAjax = function( element ){
		element.lock();
	}

	AysChartBuilder.prototype.endAjax = function( element ){
		element.unlock();
	}

	AysChartBuilder.prototype.quickSaveHotKeys = function() {
		$(document).on('keydown', function(e){
			var saveButton = $(document).find('input#ays-button-apply');
			if ( saveButton.length > 0 ) {
                if (!(e.which == 83 && e.ctrlKey) && !(e.which == 19)){
                    return true;
                }
                saveButton.trigger("click");
                e.preventDefault();
                return false;
            }
		});
	}

	// Manual data preview button
	AysChartBuilder.prototype.showOnChart = function () {
		var _this = this;
		
		var lastId = $(document).find(".ays-chart-chart-source-data-edit-block:last-child").attr('data-source-id');
		var chartData = [];

		var rowTitles = $(document).find('.ays-chart-chart-source-data-name-input-box');
		rowTitles.each(function(key, el) {
			var value = $(el).find('input').val();
			if ( value == '' ) {
				$(el).find('input').val('Option');
			}
		});

		var form = $(document).find("#ays-charts-form");
		var data = form.serializeFormJSON();

		for (var i = 0; i <= lastId; i++) {
			if (data['ays_chart_source_data['+i+'][]'] !== undefined) {
				var dataRow = data['ays_chart_source_data['+i+'][]'];
				var filteredRow = [];
				for (var key = 0; key < dataRow.length; key++) {
					var value = dataRow[key];
					if (value != '') {
						if (isNaN(value)) {
							filteredRow.push(value);
						} else {
							filteredRow.push(+value);
						}
					} else {
						if (i == 0) {
							filteredRow.push('Title'+key);
						} else {
							if (key == 2) {
								if (!(_this.chartType == 'geo_chart')) {
									filteredRow.push('0');
								}
							} else {
								filteredRow.push('0');
							}
						}
					}
				}
				if (filteredRow.length != 0) {
					chartData.push(filteredRow);
				}
			}
		}
		if (_this.chartType == 'line_chart' || _this.chartType == 'bar_chart' || _this.chartType == 'column_chart' || _this.chartType == 'area_chart' || _this.chartType == 'combo_chart' || _this.chartType == 'stepped_area_chart') {
			_this.chartTempData = _this.multiColumnChartConvertData( chartData );
		} else {
			_this.chartTempData = _this.chartConvertData( chartData );
		}

		_this.chartTempData = _this.chartSourceData.settings.enable_row_settings === 'checked' ? _this.setRowOptions(_this.chartTempData, _this.chartSourceData.settings, false) : _this.chartTempData;

		_this.chartDataArray = _this.chartTempData;
		_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );

		_this.updateChartData( _this.chartData );

		_this.chartTempData = null;
	}

	AysChartBuilder.prototype.orgTypeShowOnChart = function () {
		var _this = this;

		var form = _this.$el.find("#ays-charts-form");
		var data = form.serializeFormJSON();
		var allBranches = _this.$el.find(".tree-branch");
		var treeManual = _this.$el.find("#ays-chart-chart-source-data-edit-tree-content");

		var chartData = {};
		allBranches.each(function() {
			var branchId = $(this).attr("data-id") 
			var changedName = $(this).find(".ays-chart-org-chart-name-" + branchId).val();
			var changedDescription = $(this).find(".ays-chart-org-chart-description-" + branchId).val();
			var changedImage = $(this).find(".ays-chart-org-chart-image-" + branchId).val();
			var changedParentName = $(this).find(".ays-chart-org-chart-parent-name").val();
			var changedTooltip = $(this).find(".ays-chart-org-chart-tooltip-" + branchId).val();
			var changedUrl = $(this).find(".ays-chart-org-chart-url-" + branchId).val();
			var changedParentId = $(this).find(".ays-chart-org-chart-parent").val();

			var changedLevel = $(this).find(".ays-chart-org-chart-level").val();

			chartData[branchId] = [changedName, changedDescription, changedImage, changedParentName, changedTooltip, changedUrl, changedParentId, changedLevel]
		})

		_this.chartData = _this.orgChartConvertData( chartData );
		_this.chartTempData = _this.chartData;
		_this.chartData = window.google.visualization.arrayToDataTable( _this.chartData );
		_this.updateChartData( _this.chartData );
		chartData = null;
	}

	AysChartBuilder.prototype.htmlDecode = function (input) {
		if (!input) return input;

		var e = document.createElement('div');
		e.innerHTML = input;
		return e.childNodes[0].nodeValue;
	}

	AysChartBuilder.prototype.drawChartFunction = function (source, options) {
		var _this = this;

		var view = new google.visualization.DataView(source);
		_this.chartData = source;

		if (_this.chartType == 'geo_chart') {
			view.setColumns([0, 1]);
		} else if (_this.chartType == 'org_chart') {
			view.setColumns([0, 1, 2]);
		}

		_this.chartObj.draw(view, options);
		
		if (_this.chartType == 'word_tree') {
			_this.$el.find("#" + _this.htmlClassPrefix + _this.chartType + " svg g rect:last-child").eq(0).hide();
		}

		if (_this.chartType == 'org_chart') {
			_this.setOrgChartCustomStyles();
		}
	}

	$.fn.AysChartBuilderMain = function(options) {
        return this.each(function() {
            if (!$.data(this, 'AysChartBuilderMain')) {
                $.data(this, 'AysChartBuilderMain', new AysChartBuilder(this, options));
            } else {
                try {
                    $(this).data('AysChartBuilderMain').init();
                } catch (err) {
                    console.error('AysChartBuilderMain has not initiated properly');
                }
            }
        });
    };
    $(document).find('#ays-charts-form').AysChartBuilderMain();

})(jQuery);

(function ($) {

	$.fn.serializeFormJSON = function () {
		let o = {},
			a = this.serializeArray();
		$.each(a, function () {
			if (o[this.name]) {
				if (!o[this.name].push) {
					o[this.name] = [o[this.name]];
				}
				o[this.name].push(this.value || '');
			} else {
				o[this.name] = this.value || '';
			}
		});
		return o;
	};

	$.fn.lock = function () {
		$(this).each(function () {
			var $this = $(this);
			var position = $this.css('position');

			if (!position) {
				position = 'static';
			}

			switch (position) {
				case 'absolute':
				case 'relative':
					break;
				default:
					$this.css('position', 'relative');
					break;
			}
			$this.data('position', position);

			var width = $this.width(),
				height = $this.height();

			var locker = $('<div class="locker"></div>');
			locker.width(width).height(height);

			var loader = $('<div class="locker-loader"></div>');
			loader.width(width).height(height);

			locker.append(loader);
			$this.append(locker);
			$(window).resize(function () {
				$this.find('.locker,.locker-loader').width($this.width()).height($this.height());
			});
		});

		return $(this);
	};

	$.fn.unlock = function () {
		$(this).each(function () {
			$(this).find('.locker').remove();
			$(this).css('position', $(this).data('position'));
		});

		return $(this);
	};
})(jQuery);